/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.search.requesttype.algorithm.jql.base;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.query.Query;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.portal.PortalService;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternal;
import com.atlassian.servicedesk.internal.api.requesttype.customfield.RequestTypeCustomFieldService;
import com.atlassian.servicedesk.plugins.search.FpUtils;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchQuery;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchResult;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchResultList;
import com.atlassian.servicedesk.plugins.search.requesttype.RequestTypeSearchResultImpl;
import com.atlassian.servicedesk.plugins.search.requesttype.RequestTypeSearchResultListImpl;
import com.atlassian.servicedesk.plugins.search.requesttype.RequestTypeServiceHelper;
import com.atlassian.servicedesk.plugins.search.requesttype.algorithm.RequestTypeSearchAlgorithm;
import com.atlassian.servicedesk.plugins.search.requesttype.algorithm.jql.base.JQLRequestTypeSearcher;
import com.atlassian.servicedesk.plugins.search.requesttype.algorithm.jql.base.PartialRequestType;
import com.atlassian.servicedesk.plugins.search.requesttype.algorithm.jql.base.RequestTypeCustomFieldData;
import com.atlassian.servicedesk.plugins.search.requesttype.algorithm.jql.base.SetBatcher;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public abstract class AbstractJQLRequestTypeSearchAlgorithm
implements RequestTypeSearchAlgorithm {
    private final JQLRequestTypeSearcher jqlRequestTypeSearcher;
    private final ProjectService projectService;
    private final PortalService portalService;
    private final RequestTypeCustomFieldService requestTypeCustomFieldService;
    private final ServiceDeskService serviceDeskService;
    private final RequestTypeServiceHelper requestTypeServiceHelper;
    private static final int MAX_NUM_OF_ISSUE_TO_SEARCH_FOR = 200;

    public AbstractJQLRequestTypeSearchAlgorithm(JQLRequestTypeSearcher jqlRequestTypeSearcher, ProjectService projectService, PortalService portalService, RequestTypeCustomFieldService requestTypeCustomFieldService, ServiceDeskService serviceDeskService, RequestTypeServiceHelper requestTypeServiceHelper) {
        this.jqlRequestTypeSearcher = jqlRequestTypeSearcher;
        this.projectService = projectService;
        this.portalService = portalService;
        this.requestTypeCustomFieldService = requestTypeCustomFieldService;
        this.serviceDeskService = serviceDeskService;
        this.requestTypeServiceHelper = requestTypeServiceHelper;
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<AnError, RequestTypeSearchResultList> search(@Nonnull ApplicationUser user, @Nonnull RequestTypeSearchQuery requestTypeSearchQuery) {
        Long vpOriginId = this.requestTypeCustomFieldService.getRequestTypeCustomField().getCustomFieldId();
        return Steps.begin(this.getServiceDesk(user, requestTypeSearchQuery)).then(sdOpt -> io.atlassian.fugue.Either.right((Object)this.getJqlQueryForSearchTerm(requestTypeSearchQuery.getSearchText(), vpOriginId, (Option<ServiceDesk>)sdOpt))).then((sdOpt, query) -> this.jqlRequestTypeSearcher.performSearch((Query)query, vpOriginId, 200)).yield((sdOpt, query, searchResults) -> this.convertRtCustomFieldsToRequestTypesSearchResults(user, (Option<ServiceDesk>)sdOpt, (Set<String>)searchResults, requestTypeSearchQuery.getLimit()));
    }

    protected abstract Query getJqlQueryForSearchTerm(@Nonnull String var1, long var2, @Nonnull Option<ServiceDesk> var4);

    private RequestTypeSearchResultList convertRtCustomFieldsToRequestTypesSearchResults(ApplicationUser user, Option<ServiceDesk> sdOpt, Set<String> cfValues, int resultLimit) {
        ArrayList requestTypeSearchResults = Lists.newArrayList();
        Iterable<io.atlassian.fugue.Either<AnError, RequestType>> allValidRequestTypes = this.requestTypeServiceHelper.getAllValidRequestTypes(user, sdOpt);
        SetBatcher<String> batcher = new SetBatcher<String>(resultLimit, cfValues);
        while (batcher.hasMore()) {
            Set<String> cfValueBatch = batcher.next();
            List<PartialRequestType> partialRequestTypes = this.convertRtCustomFieldsToPartialRequestTypes(user, cfValueBatch);
            requestTypeSearchResults.addAll(this.getRequestTypeSearchResults(allValidRequestTypes, partialRequestTypes));
            if (requestTypeSearchResults.size() < resultLimit) continue;
            break;
        }
        return new RequestTypeSearchResultListImpl(Iterables.take((int)resultLimit, (Iterable)requestTypeSearchResults));
    }

    private List<PartialRequestType> convertRtCustomFieldsToPartialRequestTypes(ApplicationUser user, Set<String> sortedRequestTypeCustomFieldData) {
        return sortedRequestTypeCustomFieldData.stream().flatMap(cfValue -> FpUtils.optionToList(Steps.begin(RequestTypeCustomFieldData.parse(cfValue)).then(rtCfData -> this.getPortalByKey(user, rtCfData.getPortalKey())).yield((rtCfData, portal) -> new PartialRequestType((Portal)portal, rtCfData.getRequestTypeKey()))).stream()).collect(Collectors.toList());
    }

    private List<RequestTypeSearchResult> getRequestTypeSearchResults(Iterable<io.atlassian.fugue.Either<AnError, RequestType>> requestTypeEithers, List<PartialRequestType> partialRequestTypes) {
        ArrayList requestTypes = Lists.newArrayList();
        for (io.atlassian.fugue.Either<AnError, RequestType> requestTypeEither : requestTypeEithers) {
            requestTypeEither.foreach(rt -> {
                Option<PartialRequestType> matchingRequestTypeOpt = this.findCorrespondingPartialRequestType((RequestType)rt, partialRequestTypes);
                matchingRequestTypeOpt.forEach(matchingPartialRt -> requestTypes.add(new Pair((Object)partialRequestTypes.indexOf(matchingPartialRt), (Object)new RequestTypeSearchResultImpl((RequestType)rt, matchingPartialRt.getPortal()))));
            });
            if (requestTypes.size() != partialRequestTypes.size()) continue;
            break;
        }
        return requestTypes.stream().sorted((left, right) -> Integer.compare((Integer)left.left(), (Integer)right.left())).map(Pair::right).collect(Collectors.toList());
    }

    private Option<PartialRequestType> findCorrespondingPartialRequestType(RequestType requestType, List<PartialRequestType> partialRequestTypes) {
        return Iterables.findFirst(partialRequestTypes, partialRequestType -> {
            RequestTypeInternal requestTypeInternal = (RequestTypeInternal)requestType;
            return requestTypeInternal.getKey().equals(partialRequestType.getRequestTypeKey()) && requestTypeInternal.getPortalId() == (long)partialRequestType.getPortal().getId();
        });
    }

    private Option<Portal> getPortalByKey(ApplicationUser user, String portalKey) {
        ProjectService.GetProjectResult projectByKeyResult = this.projectService.getProjectByKey(user, portalKey.toUpperCase());
        if (!projectByKeyResult.isValid()) {
            return Option.none();
        }
        Project project = projectByKeyResult.getProject();
        io.atlassian.fugue.Either portalEither = StepsConverters.newerEither((Either)this.portalService.getPortalForProject(user, project));
        return portalEither.toOption();
    }

    private io.atlassian.fugue.Either<AnError, Option<ServiceDesk>> getServiceDesk(ApplicationUser user, RequestTypeSearchQuery requestTypeSearchQuery) {
        return FpUtils.swapEitherAndOption(requestTypeSearchQuery.getServiceDeskId().map(serviceDeskId -> StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskById(user, (long)serviceDeskId.intValue()))));
    }
}

