/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.search.requesttype.algorithm.basic;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.portal.PortalService;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.plugins.search.FpUtils;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchQuery;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchResult;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchResultList;
import com.atlassian.servicedesk.plugins.search.requesttype.RequestTypeSearchResultImpl;
import com.atlassian.servicedesk.plugins.search.requesttype.RequestTypeSearchResultListImpl;
import com.atlassian.servicedesk.plugins.search.requesttype.RequestTypeServiceHelper;
import com.atlassian.servicedesk.plugins.search.requesttype.algorithm.RequestTypeSearchAlgorithm;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BasicRequestTypeSearchAlgorithmTwo
implements RequestTypeSearchAlgorithm {
    private final RequestTypeServiceHelper requestTypeServiceHelper;
    private final PortalService portalService;
    private final ServiceDeskService serviceDeskService;

    @Autowired
    public BasicRequestTypeSearchAlgorithmTwo(RequestTypeServiceHelper requestTypeServiceHelper, PortalService portalService, ServiceDeskService serviceDeskService) {
        this.requestTypeServiceHelper = requestTypeServiceHelper;
        this.portalService = portalService;
        this.serviceDeskService = serviceDeskService;
    }

    @Override
    public String getDescription() {
        return "From all the existing request types, this algorithm matches the search query against the request type name/description and portal name, up to the configured results limit.";
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<AnError, RequestTypeSearchResultList> search(@Nonnull ApplicationUser user, @Nonnull RequestTypeSearchQuery query) {
        return Steps.begin(this.getServiceDesk(user, (Option<Integer>)query.getServiceDeskId())).then(sdOpt -> io.atlassian.fugue.Either.right(this.findRequestTypes(user, (Option<ServiceDesk>)sdOpt, query))).yield((sdOpt, searchResults) -> new RequestTypeSearchResultListImpl((Iterable<RequestTypeSearchResult>)searchResults));
    }

    private List<RequestTypeSearchResult> findRequestTypes(ApplicationUser user, Option<ServiceDesk> sdOpt, RequestTypeSearchQuery query) {
        Iterable<io.atlassian.fugue.Either<AnError, RequestType>> allValidRequestTypes = this.requestTypeServiceHelper.getAllValidRequestTypes(user, sdOpt);
        String searchText = query.getSearchText();
        int limit = query.getLimit();
        ArrayList requestTypeSearchResults = Lists.newArrayList();
        for (io.atlassian.fugue.Either<AnError, RequestType> requestTypeEither : allValidRequestTypes) {
            Steps.begin(requestTypeEither).then(requestType -> StepsConverters.newerEither((Either)this.portalService.getPortalForId(user, requestType.getPortalId()))).yield((requestType, portal) -> {
                if (StringUtils.containsIgnoreCase((String)requestType.getName(), (String)searchText) || StringUtils.containsIgnoreCase((String)requestType.getDescription(), (String)searchText) || sdOpt.isEmpty() && StringUtils.containsIgnoreCase((String)portal.getName(), (String)searchText)) {
                    RequestTypeSearchResultImpl requestTypeSearchResult = new RequestTypeSearchResultImpl(requestType.getId(), requestType.getPortalId(), requestType.getName(), requestType.getDescription(), requestType.getIssueTypeId(), requestType.getIconId(), (Option<Float>)Option.none(), portal.getName());
                    requestTypeSearchResults.add(requestTypeSearchResult);
                }
                return Unit.UNIT;
            });
            if (requestTypeSearchResults.size() < limit) continue;
            break;
        }
        return requestTypeSearchResults;
    }

    private io.atlassian.fugue.Either<AnError, Option<ServiceDesk>> getServiceDesk(ApplicationUser user, Option<Integer> serviceDeskIdOption) {
        return FpUtils.swapEitherAndOption(serviceDeskIdOption.map(serviceDeskId -> StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskById(user, (long)serviceDeskId.intValue()))));
    }
}

