/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.search.requesttype.algorithm.basic;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.portal.PortalService;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.requesttype.RequestTypeQuery;
import com.atlassian.servicedesk.api.requesttype.RequestTypeService;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchQuery;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchResultList;
import com.atlassian.servicedesk.plugins.search.requesttype.RequestTypeSearchResultImpl;
import com.atlassian.servicedesk.plugins.search.requesttype.RequestTypeSearchResultListImpl;
import com.atlassian.servicedesk.plugins.search.requesttype.algorithm.RequestTypeSearchAlgorithm;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Deprecated
@Component
public class BasicRequestTypeSearchAlgorithmThree
implements RequestTypeSearchAlgorithm {
    private final RequestTypeService requestTypeService;
    private final PortalService portalService;

    @Autowired
    public BasicRequestTypeSearchAlgorithmThree(RequestTypeService requestTypeService, PortalService portalService) {
        this.requestTypeService = requestTypeService;
        this.portalService = portalService;
    }

    @Override
    public String getDescription() {
        return "From all the existing request types, this algorithm first matches the search query against the request type name and portal name, this up to the configured results limit. If the results limit is not reached having looped through all the request types, it goes through them again and attempts to match their description.";
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<AnError, RequestTypeSearchResultList> search(@Nonnull ApplicationUser user, @Nonnull RequestTypeSearchQuery query) {
        RequestTypeSearchResultImpl requestTypeSearchResult;
        Portal portal;
        io.atlassian.fugue.Either portalEither;
        RequestTypeQuery.Builder requestTypeQueryBuilder = this.requestTypeService.newQueryBuilder();
        RequestTypeQuery requestTypeQuery = requestTypeQueryBuilder.isValid(Boolean.valueOf(true)).build();
        io.atlassian.fugue.Either allRequestTypeEither = StepsConverters.newerEither((Either)this.requestTypeService.getRequestTypes(user, requestTypeQuery));
        if (allRequestTypeEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)allRequestTypeEither.left().get());
        }
        Iterable requestTypes = (Iterable)allRequestTypeEither.right().get();
        ArrayList requestTypeSearchResults = Lists.newArrayList();
        for (RequestType requestType : requestTypes) {
            portalEither = StepsConverters.newerEither((Either)this.portalService.getPortalForId(user, requestType.getPortalId()));
            if (portalEither.isLeft()) continue;
            portal = (Portal)portalEither.right().get();
            if (!StringUtils.containsIgnoreCase((String)requestType.getName(), (String)query.getSearchText()) && !StringUtils.containsIgnoreCase((String)portal.getName(), (String)query.getSearchText())) continue;
            requestTypeSearchResult = new RequestTypeSearchResultImpl(requestType.getId(), requestType.getPortalId(), requestType.getName(), requestType.getDescription(), requestType.getIssueTypeId(), requestType.getIconId(), (Option<Float>)Option.none(), portal.getName());
            requestTypeSearchResults.add(requestTypeSearchResult);
            if (requestTypeSearchResults.size() < query.getLimit()) continue;
            break;
        }
        if (requestTypeSearchResults.size() < query.getLimit()) {
            for (RequestType requestType : requestTypes) {
                portalEither = StepsConverters.newerEither((Either)this.portalService.getPortalForId(user, requestType.getPortalId()));
                if (portalEither.isLeft()) continue;
                portal = (Portal)portalEither.right().get();
                if (!StringUtils.containsIgnoreCase((String)requestType.getDescription(), (String)query.getSearchText())) continue;
                requestTypeSearchResult = new RequestTypeSearchResultImpl(requestType.getId(), requestType.getPortalId(), requestType.getName(), requestType.getDescription(), requestType.getIssueTypeId(), requestType.getIconId(), (Option<Float>)Option.none(), portal.getName());
                requestTypeSearchResults.add(requestTypeSearchResult);
                if (requestTypeSearchResults.size() < query.getLimit()) continue;
                break;
            }
        }
        RequestTypeSearchResultListImpl requestTypeSearchResultList = new RequestTypeSearchResultListImpl(requestTypeSearchResults);
        return io.atlassian.fugue.Either.right((Object)requestTypeSearchResultList);
    }
}

