/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.search.requesttype.algorithm.basic;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.portal.PortalService;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.requesttype.RequestTypeQuery;
import com.atlassian.servicedesk.api.requesttype.RequestTypeService;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchQuery;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchResultList;
import com.atlassian.servicedesk.plugins.search.requesttype.RequestTypeSearchResultImpl;
import com.atlassian.servicedesk.plugins.search.requesttype.RequestTypeSearchResultListImpl;
import com.atlassian.servicedesk.plugins.search.requesttype.algorithm.RequestTypeSearchAlgorithm;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Deprecated
@Component
public class BasicRequestTypeSearchAlgorithm
implements RequestTypeSearchAlgorithm {
    private final RequestTypeService requestTypeService;
    private final PortalService portalService;

    @Autowired
    public BasicRequestTypeSearchAlgorithm(RequestTypeService requestTypeService, PortalService portalService) {
        this.requestTypeService = requestTypeService;
        this.portalService = portalService;
    }

    @Override
    public String getDescription() {
        return "From all the existing request types, this algorithm matches the search query against the request type name and description, up to the configured results limit.";
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<AnError, RequestTypeSearchResultList> search(@Nonnull ApplicationUser user, @Nonnull RequestTypeSearchQuery query) {
        RequestTypeQuery.Builder requestTypeQueryBuilder = this.requestTypeService.newQueryBuilder();
        RequestTypeQuery requestTypeQuery = requestTypeQueryBuilder.isValid(Boolean.valueOf(true)).build();
        io.atlassian.fugue.Either allRequestTypeEither = StepsConverters.newerEither((Either)this.requestTypeService.getRequestTypes(user, requestTypeQuery));
        if (allRequestTypeEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)allRequestTypeEither.left().get());
        }
        Iterable requestTypes = (Iterable)allRequestTypeEither.right().get();
        ArrayList requestTypeSearchResults = Lists.newArrayList();
        HashMap tempPortalCache = Maps.newHashMap();
        for (RequestType requestType : requestTypes) {
            Option portalOption;
            if (!StringUtils.containsIgnoreCase((String)requestType.getName(), (String)query.getSearchText()) && !StringUtils.containsIgnoreCase((String)requestType.getDescription(), (String)query.getSearchText())) continue;
            long portalId = requestType.getPortalId();
            if (!tempPortalCache.containsKey(portalId)) {
                io.atlassian.fugue.Either portalEither = StepsConverters.newerEither((Either)this.portalService.getPortalForId(user, portalId));
                tempPortalCache.put(portalId, portalEither.right().toOption());
            }
            if ((portalOption = (Option)tempPortalCache.get(portalId)).isEmpty()) continue;
            Portal portal = (Portal)portalOption.get();
            RequestTypeSearchResultImpl requestTypeSearchResult = new RequestTypeSearchResultImpl(requestType.getId(), requestType.getPortalId(), requestType.getName(), requestType.getDescription(), requestType.getIssueTypeId(), requestType.getIconId(), (Option<Float>)Option.none(), portal.getName());
            requestTypeSearchResults.add(requestTypeSearchResult);
            if (requestTypeSearchResults.size() < query.getLimit()) continue;
            break;
        }
        RequestTypeSearchResultListImpl requestTypeSearchResultList = new RequestTypeSearchResultListImpl(requestTypeSearchResults);
        return io.atlassian.fugue.Either.right((Object)requestTypeSearchResultList);
    }
}

