/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.search.requesttype.algorithm;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchQuery;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchQueryBuilder;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchResult;
import com.atlassian.servicedesk.plugins.search.api.requesttype.RequestTypeSearchResultList;
import com.atlassian.servicedesk.plugins.search.requesttype.RequestTypeSearchResultListImpl;
import com.atlassian.servicedesk.plugins.search.requesttype.algorithm.RequestTypeSearchAlgorithm;
import io.atlassian.fugue.Either;
import java.util.List;
import javax.annotation.Nonnull;

public class ComposedAlgorithm
implements RequestTypeSearchAlgorithm {
    private final RequestTypeSearchAlgorithm primaryAlgorithm;
    private final int primaryAlgorithmLimit;
    private final RequestTypeSearchAlgorithm secondaryAlgorithm;

    public ComposedAlgorithm(RequestTypeSearchAlgorithm primaryAlgorithm, int primaryAlgorithmLimit, RequestTypeSearchAlgorithm secondaryAlgorithm) {
        this.primaryAlgorithm = primaryAlgorithm;
        this.primaryAlgorithmLimit = primaryAlgorithmLimit;
        this.secondaryAlgorithm = secondaryAlgorithm;
    }

    @Override
    public String getDescription() {
        return "Primary algorithm: " + this.primaryAlgorithm.getDescription() + " (limit: " + this.primaryAlgorithmLimit + ")\nSecondary algorithm: " + this.secondaryAlgorithm.getDescription();
    }

    @Override
    @Nonnull
    public Either<AnError, RequestTypeSearchResultList> search(@Nonnull ApplicationUser user, @Nonnull RequestTypeSearchQuery query) {
        int restrictedPrimaryAlgoLimit = Math.min(this.primaryAlgorithmLimit, query.getLimit());
        RequestTypeSearchQuery primaryQuery = RequestTypeSearchQueryBuilder.newQuery((RequestTypeSearchQuery)query).withLimit(restrictedPrimaryAlgoLimit).build();
        return this.primaryAlgorithm.search(user, primaryQuery).map(requestTypeSearchResultList -> {
            if (requestTypeSearchResultList.requestTypeSearchResultsSize() >= query.getLimit()) {
                return requestTypeSearchResultList;
            }
            Either<AnError, RequestTypeSearchResultList> secondarySearch = this.secondaryAlgorithm.search(user, query);
            if (secondarySearch.isLeft()) {
                return requestTypeSearchResultList;
            }
            RequestTypeSearchResultList secondarySearchResultList = (RequestTypeSearchResultList)secondarySearch.right().get();
            List secondarySearchResults = secondarySearchResultList.getRequestTypeSearchResults();
            for (RequestTypeSearchResult result : secondarySearchResults) {
                boolean resultsAlreadyFoundWithPrimaryAlgo = requestTypeSearchResultList.getRequestTypeSearchResults().stream().anyMatch(input -> input.getId() == result.getId());
                if (resultsAlreadyFoundWithPrimaryAlgo) continue;
                requestTypeSearchResultList.addRequestTypeSearchResult(result);
                if (requestTypeSearchResultList.requestTypeSearchResultsSize() < query.getLimit()) continue;
                break;
            }
            return new RequestTypeSearchResultListImpl(requestTypeSearchResultList.getRequestTypeSearchResults());
        });
    }
}

