/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.timeutil;

import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.commons.lang.NotImplementedException;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Months;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.Weeks;

public enum TimeBreakdown {
    HOUR("h", Period.hours((int)1)),
    DAY("d", Period.days((int)1)),
    WEEK("w", Period.weeks((int)1)),
    MONTH("m", Period.months((int)1));

    private final String format;
    private final Period period;

    private TimeBreakdown(String format, Period period) {
        this.format = format;
        this.period = period;
    }

    public static Option<TimeBreakdown> parse(@Nullable String timeBreakdownFormat) {
        return Iterables.findFirst(Arrays.asList(TimeBreakdown.values()), timeBreakdown -> timeBreakdown.format.equals(timeBreakdownFormat));
    }

    public static Option<TimeBreakdown> byPeriod(Period period) {
        return Iterables.findFirst(Arrays.asList(TimeBreakdown.values()), timeBreakdown -> timeBreakdown.period.equals((Object)period));
    }

    public DateTime flattenDateTime(DateTime dateTime) {
        switch (this) {
            case HOUR: {
                return dateTime.hourOfDay().roundFloorCopy();
            }
            case DAY: {
                return dateTime.dayOfWeek().roundFloorCopy();
            }
            case WEEK: {
                return dateTime.dayOfWeek().roundFloorCopy().withDayOfWeek(1);
            }
            case MONTH: {
                return dateTime.dayOfWeek().roundFloorCopy().withDayOfMonth(1);
            }
        }
        throw new NotImplementedException();
    }

    public int getUnitsBetween(DateTime first, DateTime second) {
        switch (this) {
            case HOUR: {
                return Hours.hoursBetween((ReadableInstant)first, (ReadableInstant)second).getHours();
            }
            case DAY: {
                return Days.daysBetween((ReadableInstant)first, (ReadableInstant)second).getDays();
            }
            case WEEK: {
                return Weeks.weeksBetween((ReadableInstant)first, (ReadableInstant)second).getWeeks();
            }
            case MONTH: {
                return Months.monthsBetween((ReadableInstant)first, (ReadableInstant)second).getMonths();
            }
        }
        throw new NotImplementedException();
    }

    public Period getPeriod() {
        return this.period;
    }
}

