/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.series.kb;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.plugins.reports.internal.collector.CountCollector;
import com.atlassian.servicedesk.plugins.reports.internal.collector.input.DateTimeValue;
import com.atlassian.servicedesk.plugins.reports.internal.collector.result.DataCollectorResult;
import com.atlassian.servicedesk.plugins.reports.internal.dao.kb.AbstractKBEventAggregateDao;
import com.atlassian.servicedesk.plugins.reports.internal.domain.kb.AbstractKBEvent;
import com.atlassian.servicedesk.plugins.reports.internal.domain.kb.AbstractKBEventAggregate;
import com.atlassian.servicedesk.plugins.reports.internal.model.YAxisType;
import com.atlassian.servicedesk.plugins.reports.internal.series.SeriesData;
import com.atlassian.servicedesk.plugins.reports.internal.series.kb.KBEventSeriesManager;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.Timescale;
import io.atlassian.fugue.Either;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKBEventSeriesManager
implements KBEventSeriesManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Nonnull
    protected abstract AbstractKBEventAggregateDao<? extends AbstractKBEvent> getAggregateDao();

    @Override
    @Nonnull
    public Either<AnError, SeriesData> getSeriesData(@Nonnull ServiceDesk serviceDesk, @Nonnull Timescale timescale) {
        return (Either)Steps.begin(timescale.getStartTimeAsMillis()).then(firstInterval -> timescale.getEndTimeAsMillis()).yield((startTime, endTime) -> this.getAggregateDao().getSeries(serviceDesk, (long)startTime, (long)endTime)).fold(() -> {
            this.log.warn("Returning empty series as timescale has zero intervals, this is unexpected");
            return Either.right((Object)SeriesData.EMPTY_COUNT_DATA);
        }, aggregatesEither -> aggregatesEither.map(aggregates -> this.getSeriesFromAggregate((List<AbstractKBEventAggregate>)aggregates, timescale)));
    }

    private SeriesData getSeriesFromAggregate(List<AbstractKBEventAggregate> aggregates, Timescale timescale) {
        CountCollector collector = new CountCollector(timescale);
        aggregates.forEach(aggregate -> {
            DateTimeValue<Long> dateTimeValue = new DateTimeValue<Long>(aggregate.getStartTime(), aggregate.getCount());
            collector.collect(dateTimeValue);
        });
        DataCollectorResult<Long> data = collector.data();
        return new SeriesData(data, YAxisType.COUNT, (Number)data.getSeriesSummaryValue());
    }
}

