/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.series.issue;

import com.atlassian.jira.util.LuceneUtils;
import com.atlassian.pocketknife.annotations.lucene.LuceneUsage;
import com.atlassian.servicedesk.plugins.reports.internal.collector.CountCollector;
import com.atlassian.servicedesk.plugins.reports.internal.collector.input.DateTimeValue;
import java.io.IOException;
import java.util.Date;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueAggregation)
class RequestTypeSearchDataCallback
extends Collector {
    private static final Logger log = LoggerFactory.getLogger(RequestTypeSearchDataCallback.class);
    private final FieldSelector issueCreatedDate = new SingleFieldSelector("created");
    private final CountCollector countCollector;
    private IndexReader indexReader = null;

    RequestTypeSearchDataCallback(@Nonnull CountCollector countCollector) {
        this.countCollector = countCollector;
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public void collect(int i) throws IOException {
        Document document;
        String issueCreatedString;
        if (this.indexReader != null && StringUtils.isNotBlank((String)(issueCreatedString = (document = this.indexReader.document(i, this.issueCreatedDate)).get("created")))) {
            try {
                Date date = LuceneUtils.stringToDate((String)issueCreatedString);
                if (date != null) {
                    long dateTime = date.getTime();
                    this.countCollector.collect(new DateTimeValue<Long>(dateTime, 1L));
                }
            }
            catch (NumberFormatException ex) {
                log.error("Failed to parse create date {0} from Lucene index", (Object)issueCreatedString, (Object)ex);
            }
        }
    }

    public void setNextReader(IndexReader indexReader, int i) throws IOException {
        this.indexReader = indexReader;
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    private static class SingleFieldSelector
    implements FieldSelector {
        private final String fieldName;

        private SingleFieldSelector(@Nonnull String fieldName) {
            this.fieldName = fieldName;
        }

        public FieldSelectorResult accept(String fieldName) {
            if (this.fieldName.equals(fieldName)) {
                return FieldSelectorResult.LOAD_AND_BREAK;
            }
            return FieldSelectorResult.NO_LOAD;
        }
    }
}

