/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.kb;

import com.atlassian.servicedesk.plugins.reports.internal.model.PredefinedReportSeries;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.DrillDownFieldView;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.kb.PredefinedKbReportDrillDownItem;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class PredefinedKbReportDrillDownItemImpl
implements PredefinedKbReportDrillDownItem {
    private String seriesId;
    private Option<DrillDownFieldView> article;
    private Option<DrillDownFieldView> views;
    private Option<DrillDownFieldView> solvedBySelfService;
    private Option<DrillDownFieldView> createdBy;
    private Option<DrillDownFieldView> lastModified;

    public PredefinedKbReportDrillDownItemImpl(String seriesId, Option<DrillDownFieldView> article, Option<DrillDownFieldView> views, Option<DrillDownFieldView> solvedBySelfService, Option<DrillDownFieldView> createdBy, Option<DrillDownFieldView> lastModified) {
        this.seriesId = seriesId;
        this.article = article;
        this.views = views;
        this.solvedBySelfService = solvedBySelfService;
        this.createdBy = createdBy;
        this.lastModified = lastModified;
    }

    @Override
    public String getSeriesId() {
        return this.seriesId;
    }

    @Override
    public Option<DrillDownFieldView> getArticle() {
        return this.article;
    }

    @Override
    public Option<DrillDownFieldView> getViews() {
        return this.views;
    }

    @Override
    public Option<DrillDownFieldView> getSolvedBySelfService() {
        return this.solvedBySelfService;
    }

    @Override
    public Option<DrillDownFieldView> getCreatedBy() {
        return this.createdBy;
    }

    @Override
    public Option<DrillDownFieldView> getLastModified() {
        return this.lastModified;
    }

    @Override
    public List<DrillDownFieldView> toDrillDownFieldView() {
        ImmutableList.Builder row = ImmutableList.builder();
        if (this.seriesId.equals(PredefinedReportSeries.NEW_KB_ARTICLE_VIEWS_FROM_PORTAL_SERIES.getId())) {
            row.add((Object)DrillDownFieldView.getFieldView(this.getArticle()));
            row.add((Object)DrillDownFieldView.getFieldView(this.getViews()));
            row.add((Object)DrillDownFieldView.getFieldView(this.getSolvedBySelfService()));
            row.add((Object)DrillDownFieldView.getFieldView(this.getCreatedBy()));
            row.add((Object)DrillDownFieldView.getFieldView(this.getLastModified()));
        } else if (this.seriesId.equals(PredefinedReportSeries.NEW_KB_SOLVED_BY_SELF_SERVICE_SERIES.getId())) {
            row.add((Object)DrillDownFieldView.getFieldView(this.getArticle()));
            row.add((Object)DrillDownFieldView.getFieldView(this.getSolvedBySelfService()));
            row.add((Object)DrillDownFieldView.getFieldView(this.getViews()));
            row.add((Object)DrillDownFieldView.getFieldView(this.getCreatedBy()));
            row.add((Object)DrillDownFieldView.getFieldView(this.getLastModified()));
        }
        return row.build();
    }

    @Override
    public List<String> toCsvView() {
        return this.toDrillDownFieldView().stream().map(DrillDownFieldView::getFieldHtml).collect(Collectors.toList());
    }
}

