/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.export;

import com.atlassian.servicedesk.plugins.reports.internal.timeutil.TimeBreakdown;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.Timescale;
import io.atlassian.fugue.Option;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;

public class ReportExportFilenameGenerator {
    private final int REPORT_NAME_TRUNCATE_AFTER = 70;
    private final int SERIES_LABEL_TRUNCATE_AFTER = 30;
    private final String reportName;
    private final Option<String> seriesName;
    private final Timescale timescale;
    private final DateTimeZone dateTimeZone;
    private final String summaryString;

    @ParametersAreNonnullByDefault
    public ReportExportFilenameGenerator(String reportName, Timescale timescale, DateTimeZone dateTimeZone, String summaryString, Option<String> seriesName) {
        this.reportName = reportName;
        this.timescale = timescale;
        this.seriesName = seriesName;
        this.summaryString = summaryString;
        this.dateTimeZone = dateTimeZone;
    }

    public String generate(long startInstant, long endInstant) {
        String dateRangeString = this.dateRangeString(startInstant, endInstant);
        String cleanedReportName = this.cleanName(this.reportName, 70);
        if (this.seriesName.isEmpty()) {
            return String.format("%s_%s_%s_by_%s", cleanedReportName, this.summaryString, dateRangeString, this.breakdownResolution());
        }
        String seriesLabel = this.cleanName((String)this.seriesName.get(), 30);
        return String.format("%s_%s_%s_%s", cleanedReportName, seriesLabel, dateRangeString, this.breakdownResolution());
    }

    private String cleanName(String name, int truncate_after) {
        String translatedChars = name.replace(" ", "_").replace("\"", "'").replace("\n", "_");
        return StringUtils.abbreviate((String)translatedChars, (int)truncate_after);
    }

    private String breakdownResolution() {
        return this.timescale.getTimeBreakdown().toString().toLowerCase();
    }

    private String dateRangeString(long startInstant, long endInstant) {
        String startStr = this.instantToDateTimeString(startInstant);
        long AN_HOUR = Period.hours((int)1).toStandardDuration().getMillis();
        if (startStr.equals(this.instantToDateTimeString(endInstant - 1L)) || startStr.equals(this.instantToDateTimeString(endInstant - AN_HOUR))) {
            return startStr;
        }
        return String.format("%s_to_%s", startStr, this.instantToDateTimeString(endInstant));
    }

    private String instantToDateTimeString(long instant) {
        DateTime dateTime = new DateTime(instant).withZone(this.dateTimeZone);
        if (this.timescale.getTimeBreakdown().equals((Object)TimeBreakdown.HOUR)) {
            return dateTime.toString("yyyy-MM-dd_HHmm");
        }
        return dateTime.toString("yyyy-MM-dd");
    }
}

