/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.export;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.sla.metrics.TimeMetric;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.api.util.paging.SimplePagedRequest;
import com.atlassian.servicedesk.internal.api.report.Series;
import com.atlassian.servicedesk.internal.api.report.series.SeriesDataTypeKeys;
import com.atlassian.servicedesk.internal.api.sla.util.SlaDurationFormatter;
import com.atlassian.servicedesk.plugins.reports.internal.i18n.CommonI18n;
import com.atlassian.servicedesk.plugins.reports.internal.model.PredefinedReportSeries;
import com.atlassian.servicedesk.plugins.reports.internal.reportdata.CustomReportData;
import com.atlassian.servicedesk.plugins.reports.internal.rest.ReportsDrilldownResourceHelper;
import com.atlassian.servicedesk.plugins.reports.internal.rest.response.ReportDataResponse;
import com.atlassian.servicedesk.plugins.reports.internal.rest.response.ReportSeriesResponse;
import com.atlassian.servicedesk.plugins.reports.internal.series.Point;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.DrillDownColumnHeading;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.ReportDrillDownItem;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.ReportDrillDownPagedData;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.ReportDrillDownQueryHelper;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.Timescale;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.UserTimeZoneService;
import com.google.common.base.Function;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReportExportFileStreamHelper {
    private final SlaDurationFormatter slaDurationFormatter;
    private final CommonI18n commonI18n;
    private final ReportDrillDownQueryHelper reportDrillDownQueryHelper;
    private final UserTimeZoneService userTimeZoneService;
    private final ReportsDrilldownResourceHelper reportsDrilldownResourceHelper;
    private final I18nHelper i18nHelper;
    private static final Logger log = LoggerFactory.getLogger(ReportExportFileStreamHelper.class);
    private static final int EXPORT_BATCH_SIZE = 100;
    private static final int DATE_INDEX = 0;
    private static final int STAT_INDEX = 1;

    @Autowired
    public ReportExportFileStreamHelper(SlaDurationFormatter slaDurationFormatter, CommonI18n commonI18n, ReportDrillDownQueryHelper reportDrillDownQueryHelper, UserTimeZoneService userTimeZoneService, ReportsDrilldownResourceHelper reportsDrilldownResourceHelper, I18nHelper i18nHelper) {
        this.slaDurationFormatter = slaDurationFormatter;
        this.commonI18n = commonI18n;
        this.reportDrillDownQueryHelper = reportDrillDownQueryHelper;
        this.userTimeZoneService = userTimeZoneService;
        this.reportsDrilldownResourceHelper = reportsDrilldownResourceHelper;
        this.i18nHelper = i18nHelper;
    }

    public StreamingOutput getDrillDownCsvStream(PredefinedReportSeries series, Function<PagedRequest, Either<AnError, ReportDrillDownPagedData>> processor) {
        List columnNames = this.reportsDrilldownResourceHelper.getColumnNamesForPredefinedSeries(series.getId(), this.i18nHelper).stream().map(DrillDownColumnHeading::getColumnName).collect(Collectors.toList());
        return outputStream -> this.printDrilldownCsv(outputStream, columnNames, processor);
    }

    public StreamingOutput getDrillDownCsvStream(CheckedUser user, Series series, ServiceDesk serviceDesk, Function<PagedRequest, Either<AnError, ReportDrillDownPagedData>> processor) {
        Option<String> dynamicColumnHeading = this.getColumnHeading(series, serviceDesk, user);
        String seriesType = series.getSeriesType().getTypeKey();
        List<String> columnNames = this.generateIssueDrilldownColumnHeadings(seriesType, dynamicColumnHeading);
        return outputStream -> this.printDrilldownCsv(outputStream, columnNames, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printDrilldownCsv(OutputStream outputStream, List<String> columnNames, Function<PagedRequest, Either<AnError, ReportDrillDownPagedData>> processor) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        CSVPrinter printer = new CSVPrinter((Appendable)writer, CSVFormat.DEFAULT);
        try {
            printer.printRecord(columnNames);
            printer.flush();
            boolean hasNext = true;
            int startingIndex = 0;
            while (hasNext) {
                PagedRequest pagedRequest = SimplePagedRequest.paged((int)startingIndex, (int)100);
                Either pageEither = (Either)processor.apply((Object)pagedRequest);
                if (pageEither.isRight()) {
                    ReportDrillDownPagedData page = (ReportDrillDownPagedData)pageEither.right().get();
                    for (ReportDrillDownItem item : page.getResults()) {
                        printer.printRecord(item.toCsvView());
                    }
                    startingIndex += page.size();
                    hasNext = page.hasNextPage();
                    printer.flush();
                    continue;
                }
                hasNext = false;
            }
        }
        catch (IOException e) {
            log.error("An error occurred when streaming the csv");
        }
        finally {
            printer.flush();
            printer.close();
        }
    }

    private Option<String> getColumnHeading(Series series, ServiceDesk serviceDesk, CheckedUser user) {
        Option columnHeading = Option.none();
        if (SeriesDataTypeKeys.PERCENTAGE_SERIES_TYPE_KEY.getTypeKey().equals(series.getSeriesType().getTypeKey())) {
            Either<AnError, TimeMetric> timeMetric = this.reportDrillDownQueryHelper.getTimeMetric(user.forJIRA(), serviceDesk, series);
            if (timeMetric.isLeft()) {
                return Option.none();
            }
            columnHeading = Option.some((Object)((TimeMetric)timeMetric.right().get()).getName());
        }
        return columnHeading;
    }

    private List<String> generateIssueDrilldownColumnHeadings(String seriesType, Option<String> dynamicColumnHeading) {
        ArrayList<String> columnNames = new ArrayList<String>(this.commonI18n.COMMON_COLUMNS());
        if (SeriesDataTypeKeys.CREATED_COUNT_SERIES_TYPE_KEY.getTypeKey().equals(seriesType)) {
            columnNames.add(this.commonI18n.ISSUE_STATUS());
        } else if (SeriesDataTypeKeys.RESOLVED_COUNT_SERIES_TYPE_KEY.getTypeKey().equals(seriesType)) {
            columnNames.add(this.commonI18n.ISSUE_RESOLUTION());
        } else if (SeriesDataTypeKeys.AVERAGE_RATING_SERIES_TYPE_KEY.getTypeKey().equals(seriesType)) {
            columnNames.add(this.commonI18n.REQUEST_CSAT());
        } else if (SeriesDataTypeKeys.SLA_BREACHED_SERIES_TYPE_KEY.getTypeKey().equals(seriesType)) {
            columnNames.add(this.commonI18n.SLA_BREACHED());
        } else if (SeriesDataTypeKeys.SLA_SUCCEEDED_SERIES_TYPE_KEY.getTypeKey().equals(seriesType)) {
            columnNames.add(this.commonI18n.SLA_MET());
        } else if (SeriesDataTypeKeys.TIME_METRIC_ELAPSED_TIME_SERIES_TYPE_KEY.getTypeKey().equals(seriesType)) {
            columnNames.add(this.commonI18n.SLA_ELAPSED());
        } else if (dynamicColumnHeading.isDefined()) {
            columnNames.add((String)dynamicColumnHeading.get());
        }
        return columnNames;
    }

    public StreamingOutput convertSummaryDataToCsvStream(CheckedUser user, List<CustomReportData> summaryData, Timescale timescale) {
        List<List<String>> csvDataRows = this.convertSummaryDataToCsv(summaryData, user, timescale);
        return outputStream -> this.printSummaryCsv(outputStream, csvDataRows);
    }

    public StreamingOutput convertSummaryDataToCsvStream(CheckedUser user, ReportDataResponse summaryData, Timescale timescale) {
        List<List<String>> csvDataRows = this.convertPredefinedSummaryDataToCsv(summaryData.getSeries(), user, timescale);
        return outputStream -> this.printSummaryCsv(outputStream, csvDataRows);
    }

    private void printSummaryCsv(OutputStream outputStream, List<List<String>> csvDataRows) {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        try (CSVPrinter printer = new CSVPrinter((Appendable)writer, CSVFormat.DEFAULT);){
            for (List<String> row : csvDataRows) {
                printer.printRecord(row);
            }
        }
        catch (IOException e) {
            log.error("An error occurred when streaming the csv");
        }
    }

    private List<List<String>> convertSummaryDataToCsv(List<CustomReportData> listOfCustomReportData, CheckedUser user, Timescale timescale) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        if (!listOfCustomReportData.isEmpty()) {
            int totalRows = listOfCustomReportData.get(0).getData().size();
            ArrayList<String> titleRow = new ArrayList<String>();
            titleRow.add(user.i18NHelper().getText("sd.project.reports.date"));
            titleRow.addAll(listOfCustomReportData.stream().map(CustomReportData::getSeriesLabel).collect(Collectors.toList()));
            rows.add(titleRow);
            for (int rowNum = 0; rowNum < totalRows; ++rowNum) {
                boolean firstSeries = true;
                ArrayList<String> row = new ArrayList<String>();
                for (CustomReportData series : listOfCustomReportData) {
                    List<List<Number>> seriesData = series.getData();
                    List<Number> timePointData = seriesData.get(rowNum);
                    if (firstSeries) {
                        Long instant = timePointData.get(0).longValue();
                        row.add(this.formatDateTimeWithTimescale(instant, user.forJIRA(), timescale));
                        firstSeries = false;
                    }
                    if (SeriesDataTypeKeys.TIME_METRIC_ELAPSED_TIME_SERIES_TYPE_KEY.getTypeKey().equals(series.getSeriesKey())) {
                        Long data = timePointData.get(1).longValue();
                        row.add(this.slaDurationFormatter.getShortFormattedRemainingDuration(data.longValue(), user.forJIRA()));
                        continue;
                    }
                    if (SeriesDataTypeKeys.PERCENTAGE_SERIES_TYPE_KEY.getTypeKey().equals(series.getSeriesKey())) {
                        DecimalFormat formatter = new DecimalFormat("#.000");
                        row.add(formatter.format(timePointData.get(1)));
                        continue;
                    }
                    row.add(timePointData.get(1).toString());
                }
                rows.add(row);
            }
        }
        return rows;
    }

    private List<List<String>> convertPredefinedSummaryDataToCsv(List<ReportSeriesResponse> predefinedReportData, CheckedUser user, Timescale timescale) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        if (!predefinedReportData.isEmpty()) {
            ArrayList<String> titleRow = new ArrayList<String>();
            titleRow.add(user.i18NHelper().getText("sd.project.reports.date"));
            titleRow.addAll(predefinedReportData.stream().map(ReportSeriesResponse::getLabel).collect(Collectors.toList()));
            rows.add(titleRow);
            int totalRows = predefinedReportData.get(0).getData().size();
            for (int rowNum = 0; rowNum < totalRows; ++rowNum) {
                ArrayList<String> row = new ArrayList<String>();
                Long rowTimeStamp = predefinedReportData.get(0).getData().get(rowNum).getX().longValue();
                row.add(this.formatDateTimeWithTimescale(rowTimeStamp, user.forJIRA(), timescale));
                for (ReportSeriesResponse series : predefinedReportData) {
                    List<Point> seriesData = series.getData();
                    Point singlePoint = seriesData.get(rowNum);
                    row.add(singlePoint.getY().toString());
                }
                rows.add(row);
            }
        }
        return rows;
    }

    private String formatDateTimeWithTimescale(Long instant, ApplicationUser user, Timescale timescale) {
        DateTimeZone dateTimeZone = this.userTimeZoneService.getUserDateTimeZone(user);
        DateTime dateTime = new DateTime((Object)instant).withZone(dateTimeZone);
        switch (timescale.getTimeBreakdown()) {
            case HOUR: {
                return dateTime.toString("d MMM YYYY ha");
            }
            default: {
                return dateTime.toString("d MMM YYYY");
            }
            case WEEK: {
                return "Week starting " + dateTime.toString("d MMM YYYY");
            }
            case MONTH: 
        }
        return dateTime.toString("MMMM YYYY");
    }
}

