/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.series.drilldown;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.sla.metrics.TimeMetric;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequest;
import com.atlassian.servicedesk.api.util.paging.LimitedPagedRequestImpl;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.api.util.paging.PagedResponseImpl;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseService;
import com.atlassian.servicedesk.internal.api.report.Series;
import com.atlassian.servicedesk.internal.api.report.series.SeriesDataTypeKeys;
import com.atlassian.servicedesk.internal.api.report.series.SeriesService;
import com.atlassian.servicedesk.internal.api.user.ServiceDeskUserTimeZoneService;
import com.atlassian.servicedesk.internal.api.util.paging.PaginationHelper;
import com.atlassian.servicedesk.plugins.reports.internal.model.PredefinedReportSeries;
import com.atlassian.servicedesk.plugins.reports.internal.reportdata.CustomReportDataService;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.ReportDrillDownItem;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.ReportDrillDownPagedData;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.ReportDrillDownPagedDataImpl;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.ReportDrillDownQueryData;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.ReportDrillDownQueryHelper;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.ReportDrillDownService;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.issue.ReportDrillDownIssueService;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.kb.PredefinedReportDrillDownService;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.Timescale;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReportDrillDownServiceImpl
implements ReportDrillDownService {
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final ErrorResultHelper errorResultHelper;
    private final ReportDrillDownIssueService reportDrillDownIssueService;
    private final PredefinedReportDrillDownService predefinedReportDrillDownService;
    private final SeriesService seriesService;
    private final UserFactory userFactory;
    private final ServiceDeskService serviceDeskService;
    private final CustomReportDataService customReportDataService;
    private final ServiceDeskUserTimeZoneService serviceDeskUserTimeZoneService;
    private final ReportDrillDownQueryHelper reportDrillDownQueryHelper;
    private final ConfluenceKnowledgeBaseService confluenceKnowledgeBaseService;
    private static final int DRILLDOWN_PAGE_MAX_LIMIT = 2000;

    @Autowired
    ReportDrillDownServiceImpl(ServiceDeskPermissionService serviceDeskPermissionService, ErrorResultHelper errorResultHelper, ReportDrillDownIssueService reportDrillDownIssueService, PredefinedReportDrillDownService predefinedReportDrillDownService, SeriesService seriesService, UserFactory userFactory, ServiceDeskService serviceDeskService, CustomReportDataService customReportDataService, ServiceDeskUserTimeZoneService serviceDeskUserTimeZoneService, ReportDrillDownQueryHelper reportDrillDownQueryHelper, ConfluenceKnowledgeBaseService confluenceKnowledgeBaseService) {
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.reportDrillDownIssueService = reportDrillDownIssueService;
        this.errorResultHelper = errorResultHelper;
        this.predefinedReportDrillDownService = predefinedReportDrillDownService;
        this.seriesService = seriesService;
        this.userFactory = userFactory;
        this.serviceDeskService = serviceDeskService;
        this.customReportDataService = customReportDataService;
        this.serviceDeskUserTimeZoneService = serviceDeskUserTimeZoneService;
        this.reportDrillDownQueryHelper = reportDrillDownQueryHelper;
        this.confluenceKnowledgeBaseService = confluenceKnowledgeBaseService;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, ReportDrillDownPagedData> getDrillDownPagedData(ApplicationUser user, Project project, Timescale timescale, String seriesId, PagedRequest pagedRequest) {
        LimitedPagedRequest limitedPagedRequest = LimitedPagedRequestImpl.create((PagedRequest)pagedRequest, (int)2000);
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user, project))).then(serviceDesk -> this.predefinedReportDrillDownService.getTotalNumberOfDrillDownItemsForSeries(user, (ServiceDesk)serviceDesk, seriesId)).then((serviceDesk, total) -> this.predefinedReportDrillDownService.getDrillDownArticlesForSeries(user, project, (ServiceDesk)serviceDesk, seriesId, timescale, limitedPagedRequest)).yield((serviceDesk, total, items) -> this.createPagedRequest((List<? extends ReportDrillDownItem>)items, limitedPagedRequest, (long)total));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, ReportDrillDownPagedData> getDrillDownPagedData(ApplicationUser user, Project project, Timescale timescale, long seriesId, PagedRequest pagedRequest) {
        LimitedPagedRequest limitedPagedRequest = LimitedPagedRequestImpl.create((PagedRequest)pagedRequest, (int)2000);
        io.atlassian.fugue.Either<AnError, ReportDrillDownQueryData> drillDownData = this.getDrillDownData(user, project, timescale, seriesId, limitedPagedRequest);
        return Steps.begin(drillDownData).then(data -> StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user, project))).then((data, serviceDesk) -> this.reportDrillDownIssueService.getDrillDownIssuesForSeries(user, (ServiceDesk)serviceDesk, data.getPageIssues(), data.getSeriesType(), data.getTimeMetric())).yield((data, serviceDesk, issues) -> this.createPagedRequest((List<? extends ReportDrillDownItem>)issues, limitedPagedRequest, data.getTotalIssues()));
    }

    @Override
    public Function<PagedRequest, io.atlassian.fugue.Either<AnError, ReportDrillDownPagedData>> getDrillDownExportPageRetriever(ApplicationUser user, Project project, Timescale timescale, long seriesId) {
        return pagedRequest -> {
            LimitedPagedRequest limitedPagedRequest = LimitedPagedRequestImpl.create((PagedRequest)pagedRequest, (int)2000);
            io.atlassian.fugue.Either<AnError, ReportDrillDownQueryData> drillDownData = this.getDrillDownData(user, project, timescale, seriesId, limitedPagedRequest);
            return Steps.begin(drillDownData).then(data -> StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user, project))).then((data, serviceDesk) -> this.reportDrillDownIssueService.getDrillDownIssuesForSeries(user, (ServiceDesk)serviceDesk, data.getPageIssues(), data.getSeriesType(), data.getTimeMetric())).yield((data, serviceDesk, issues) -> this.createPagedRequest((List<? extends ReportDrillDownItem>)issues, limitedPagedRequest, data.getTotalIssues()));
        };
    }

    @Override
    public Function<PagedRequest, io.atlassian.fugue.Either<AnError, ReportDrillDownPagedData>> getDrillDownExportPageRetriever(ApplicationUser user, Project project, Timescale timescale, PredefinedReportSeries series) {
        return pagedRequest -> {
            LimitedPagedRequest limitedPagedRequest = LimitedPagedRequestImpl.create((PagedRequest)pagedRequest, (int)2000);
            return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user, project))).then(servicedesk -> this.confluenceKnowledgeBaseService.getKBLink(user, project)).then((serviceDesk, kbLink) -> this.predefinedReportDrillDownService.getDrillDownArticlesForSeries(user, project, (ServiceDesk)serviceDesk, series.getId(), timescale, limitedPagedRequest)).then((serviceDesk, kbLink, pageItems) -> this.predefinedReportDrillDownService.getTotalNumberOfDrillDownItemsForSeries(user, (ServiceDesk)serviceDesk, series.getId())).yield((serviceDesk, kbLink, pageItems, totalItems) -> this.createPagedRequest((List<? extends ReportDrillDownItem>)pageItems, limitedPagedRequest, (long)totalItems));
        };
    }

    private ReportDrillDownPagedData createPagedRequest(List<? extends ReportDrillDownItem> items, LimitedPagedRequest limitedPagedRequest, long total) {
        List drillDownItems = items.stream().map(i -> i).collect(Collectors.toList());
        PagedResponseImpl.Builder builder = PagedResponseImpl.from(drillDownItems, (total > (long)(limitedPagedRequest.getStart() + limitedPagedRequest.getLimit()) ? 1 : 0) != 0);
        return new ReportDrillDownPagedDataImpl((PagedResponseImpl.Builder<ReportDrillDownItem>)builder.pageRequest(limitedPagedRequest), total);
    }

    private io.atlassian.fugue.Either<AnError, ReportDrillDownQueryData> getDrillDownData(ApplicationUser user, Project project, Timescale timescale, long seriesId, LimitedPagedRequest limitedPagedRequest) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user, project))).then(serviceDesk -> this.checkIsPermitted(user, (ServiceDesk)serviceDesk)).then((serviceDesk, appUser) -> StepsConverters.newerEither((Either)this.userFactory.wrap(appUser))).then((serviceDesk, appUser, checkedUser) -> this.seriesService.getSeries(checkedUser, project, seriesId)).then((serviceDesk, appUser, checkedUser, series) -> this.getSeriesSpecificPagedData(user, (ServiceDesk)serviceDesk, (Series)series, limitedPagedRequest, timescale)).yield((serviceDesk, appUser, checkedUser, series, data) -> data);
    }

    private io.atlassian.fugue.Either<AnError, ReportDrillDownQueryData> getSeriesSpecificPagedData(ApplicationUser user, ServiceDesk sd, Series series, LimitedPagedRequest limitedPagedRequest, Timescale timescale) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).then(checkedUser -> {
            TimeZone zone = this.serviceDeskUserTimeZoneService.getUserTimeZone(checkedUser);
            return io.atlassian.fugue.Either.right((Object)DateTimeZone.forTimeZone((TimeZone)zone));
        }).then((checkedUser, timezone) -> io.atlassian.fugue.Either.right(this.customReportDataService.collectIssuesForDrilldown(series, (CheckedUser)checkedUser, sd, timescale, (DateTimeZone)timezone))).then((checkedUser, timezone, collectedIssues) -> this.getTimeMetricOpt(series, user, sd)).then((checkedUser, timezone, collectedIssues, timeMetricOpt) -> {
            io.atlassian.fugue.Either seriesTypeEither = SeriesDataTypeKeys.fromString((String)series.getSeriesType().getTypeKey()).toRight(() -> this.errorResultHelper.badRequest400("sd.report.series.error.series.type.invalid", new Object[0]).build());
            return seriesTypeEither.map(seriesType -> {
                TreeSet paginatedIssues = Sets.newTreeSet((Iterable)PaginationHelper.toPage((LimitedPagedRequest)limitedPagedRequest, (Collection)collectedIssues));
                return new ReportDrillDownQueryData(collectedIssues.size(), paginatedIssues, (SeriesDataTypeKeys)seriesType, (Option<TimeMetric>)timeMetricOpt);
            });
        }).yield((checkedUser, timezone, callback, timeMetricOpt, reportDrillDownQueryData) -> reportDrillDownQueryData);
    }

    private io.atlassian.fugue.Either<AnError, Option<TimeMetric>> getTimeMetricOpt(Series series, ApplicationUser appUser, ServiceDesk serviceDesk) {
        Option typeKeyOpt = SeriesDataTypeKeys.fromString((String)series.getSeriesType().getTypeKey());
        if (typeKeyOpt.isEmpty()) {
            return io.atlassian.fugue.Either.right((Object)Option.none());
        }
        switch ((SeriesDataTypeKeys)typeKeyOpt.get()) {
            case SLA_SUCCEEDED_SERIES_TYPE_KEY: 
            case SLA_BREACHED_SERIES_TYPE_KEY: 
            case TIME_METRIC_ELAPSED_TIME_SERIES_TYPE_KEY: 
            case PERCENTAGE_SERIES_TYPE_KEY: {
                io.atlassian.fugue.Either<AnError, TimeMetric> timeMetricResult = this.reportDrillDownQueryHelper.getTimeMetric(appUser, serviceDesk, series);
                if (timeMetricResult.isLeft()) {
                    return io.atlassian.fugue.Either.left((Object)timeMetricResult.left().get());
                }
                return io.atlassian.fugue.Either.right((Object)timeMetricResult.toOption());
            }
        }
        return io.atlassian.fugue.Either.right((Object)Option.none());
    }

    private io.atlassian.fugue.Either<AnError, ApplicationUser> checkIsPermitted(ApplicationUser user, ServiceDesk sd) {
        return StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAgent(user, sd)).flatMap(isPermitted -> Eithers.cond((boolean)isPermitted, (Object)this.errorResultHelper.forbidden403("sd.project.reports.not.permitted.view.report", new Object[0]).build(), (Object)user));
    }
}

