/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.series;

import com.atlassian.servicedesk.api.util.fp.FpKit;
import com.atlassian.servicedesk.plugins.reports.internal.collector.result.DataCollectorResult;
import com.atlassian.servicedesk.plugins.reports.internal.model.YAxisType;
import com.atlassian.servicedesk.plugins.reports.internal.series.Point;
import com.google.common.collect.Lists;
import java.util.List;

public class SeriesData {
    public static final SeriesData EMPTY_COUNT_DATA = new SeriesData(Lists.newArrayList(), YAxisType.COUNT, (Number)0);
    private final List<Point> data;
    private final YAxisType yAxisType;
    private final Number seriesSummaryValue;

    public SeriesData(DataCollectorResult<Long> data, YAxisType yAxisType, Number seriesSummaryValue) {
        this.data = this.intervalValuesToPoints(data);
        this.yAxisType = yAxisType;
        this.seriesSummaryValue = seriesSummaryValue;
    }

    private SeriesData(List<Point> data, YAxisType yAxisType, Number seriesSummaryValue) {
        this.data = data;
        this.yAxisType = yAxisType;
        this.seriesSummaryValue = seriesSummaryValue;
    }

    public List<Point> getData() {
        return this.data;
    }

    public YAxisType getYAxisType() {
        return this.yAxisType;
    }

    public Number getSeriesSummaryValue() {
        return this.seriesSummaryValue;
    }

    private List<Point> intervalValuesToPoints(DataCollectorResult<Long> result) {
        return FpKit.map(result.getIntervalValues(), intervalCount -> new Point(intervalCount.getInterval().getStartMillis(), (Number)intervalCount.getValue()));
    }
}

