/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.api.util.paging.PagedRequest;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.report.CustomReportService;
import com.atlassian.servicedesk.internal.api.report.ReportTimescale;
import com.atlassian.servicedesk.internal.api.report.ReportTimescaleManager;
import com.atlassian.servicedesk.internal.api.report.Series;
import com.atlassian.servicedesk.internal.api.report.series.SeriesService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.plugins.reports.internal.ReportService;
import com.atlassian.servicedesk.plugins.reports.internal.helper.ReportTimescaleConversionHelper;
import com.atlassian.servicedesk.plugins.reports.internal.model.PredefinedReport;
import com.atlassian.servicedesk.plugins.reports.internal.model.PredefinedReportSeries;
import com.atlassian.servicedesk.plugins.reports.internal.reportdata.CustomReportData;
import com.atlassian.servicedesk.plugins.reports.internal.reportdata.CustomReportDataService;
import com.atlassian.servicedesk.plugins.reports.internal.rest.ReportsBaseResource;
import com.atlassian.servicedesk.plugins.reports.internal.rest.response.ReportDataResponse;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.ReportDrillDownPagedData;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.ReportDrillDownService;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.export.ReportExportFileStreamHelper;
import com.atlassian.servicedesk.plugins.reports.internal.series.drilldown.export.ReportExportFilenameGenerator;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.Timescale;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.UserTimeZoneService;
import com.google.common.base.Function;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePeriod;

@Path(value="servicedesk/{projectKey}/export")
@Produces(value={"*/*"})
@Consumes(value={"application/json"})
public class ReportsExportResource
extends ReportsBaseResource {
    private final UserTimeZoneService userTimeZoneService;
    private final ReportDrillDownService reportDrillDownService;
    private final ErrorResultHelper errorResultHelper;
    private final ReportTimescaleManager reportTimescaleManager;
    private final RestResponseHelper restResponseHelper;
    private final UserFactory userFactory;
    private final SeriesService seriesService;
    private final ReportTimescaleConversionHelper reportTimescaleConversionHelper;
    private final InternalServiceDeskService internalServiceDeskService;
    private final ReportExportFileStreamHelper reportExportFileStreamHelper;
    private final I18nHelper i18nHelper;
    private final CustomReportService customReportService;
    private final ReportService reportService;
    private final CustomReportDataService customReportDataService;

    public ReportsExportResource(UserTimeZoneService userTimeZoneService, ErrorResultHelper errorResultHelper, ProjectService projectService, ReportDrillDownService reportDrillDownService, ReportTimescaleManager reportTimescaleManager, RestResponseHelper restResponseHelper, UserFactory userFactory, SeriesService seriesService, ReportTimescaleConversionHelper reportTimescaleConversionHelper, InternalServiceDeskService internalServiceDeskService, ReportExportFileStreamHelper reportExportFileStreamHelper, I18nHelper i18nHelper, CustomReportService customReportService, ReportService reportService, CustomReportDataService customReportDataService) {
        super(projectService);
        this.userTimeZoneService = userTimeZoneService;
        this.reportDrillDownService = reportDrillDownService;
        this.errorResultHelper = errorResultHelper;
        this.reportTimescaleManager = reportTimescaleManager;
        this.restResponseHelper = restResponseHelper;
        this.userFactory = userFactory;
        this.seriesService = seriesService;
        this.reportTimescaleConversionHelper = reportTimescaleConversionHelper;
        this.internalServiceDeskService = internalServiceDeskService;
        this.reportExportFileStreamHelper = reportExportFileStreamHelper;
        this.i18nHelper = i18nHelper;
        this.customReportService = customReportService;
        this.reportService = reportService;
        this.customReportDataService = customReportDataService;
    }

    @GET
    @Path(value="/series/predefined/{reportId}/{seriesId}/csv")
    public Response getPredefinedReportDrillDownExportCSV(@PathParam(value="projectKey") String projectKey, @PathParam(value="reportId") String reportId, @PathParam(value="seriesId") String seriesId, @QueryParam(value="date") Long date, @QueryParam(value="timescaleId") Long timescaleId) {
        if (date == null) {
            AnError err = this.errorResultHelper.badRequest400("sd.project.reports.date.invalid", new Object[0]).build();
            return this.restResponseHelper.anErrorToResponse(err);
        }
        return (Response)Eithers.merge((io.atlassian.fugue.Either)Steps.begin(this.getTimescaleFromId(date, timescaleId)).then(timescale -> StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then((timescale, user) -> this.getProject(projectKey)).then((timescale, user, project) -> this.internalServiceDeskService.getServiceDeskForProject(user, project, false)).then((timescale, user, project, serviceDesk) -> this.createPredefinedDrilldownCsv((CheckedUser)user, (Project)project, seriesId, reportId, (Timescale)timescale, date)).yield((timescale, user, project, serviceDesk, csvResponse) -> csvResponse).leftMap(error -> this.restResponseHelper.anErrorToResponse(error)));
    }

    @GET
    @Path(value="/series/{seriesId}/csv")
    public Response getCustomReportDrillDownExportCSV(@PathParam(value="projectKey") String projectKey, @PathParam(value="seriesId") Long seriesId, @QueryParam(value="date") Long date, @QueryParam(value="timescaleId") Long timescaleId) {
        if (date == null) {
            AnError err = this.errorResultHelper.badRequest400("sd.project.reports.date.invalid", new Object[0]).build();
            return this.restResponseHelper.anErrorToResponse(err);
        }
        return (Response)Eithers.merge((io.atlassian.fugue.Either)Steps.begin(this.getTimescaleFromId(date, timescaleId)).then(timescale -> StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then((timescale, user) -> this.getProject(projectKey)).then((timescale, user, project) -> this.internalServiceDeskService.getServiceDeskForProject(user, project, false)).then((timescale, user, project, serviceDesk) -> this.createDrilldownCsv((CheckedUser)user, (Project)project, seriesId, (ServiceDesk)serviceDesk, (Timescale)timescale, date)).yield((timescale, user, project, serviceDesk, csvResponse) -> csvResponse).leftMap(error -> this.restResponseHelper.anErrorToResponse(error)));
    }

    private io.atlassian.fugue.Either<AnError, Response> createPredefinedDrilldownCsv(CheckedUser user, Project project, String seriesId, String reportId, Timescale timescale, Long date) {
        return Steps.begin((io.atlassian.fugue.Either)PredefinedReportSeries.fromId(seriesId).toRight(() -> this.errorResultHelper.notFound404("sd.report.error.missing", new Object[0]).build())).then(series -> PredefinedReport.fromId(reportId).toRight(() -> this.errorResultHelper.notFound404("sd.report.error.missing", new Object[0]).build())).then((series, report) -> io.atlassian.fugue.Either.right(this.reportDrillDownService.getDrillDownExportPageRetriever(user.forJIRA(), project, timescale, (PredefinedReportSeries)((Object)series)))).then((series, report, processor) -> io.atlassian.fugue.Either.right((Object)this.reportExportFileStreamHelper.getDrillDownCsvStream((PredefinedReportSeries)((Object)series), (Function<PagedRequest, io.atlassian.fugue.Either<AnError, ReportDrillDownPagedData>>)processor))).then((series, report, processor, csvStream) -> this.generateDrilldownFilename(user, report.getId(), timescale, date, series.getId())).yield((series, report, processor, csvStream, filename) -> this.createCsvResponseFromStream((StreamingOutput)csvStream, (String)filename));
    }

    private io.atlassian.fugue.Either<AnError, Response> createDrilldownCsv(CheckedUser user, Project project, Long seriesId, ServiceDesk serviceDesk, Timescale timescale, Long date) {
        Function<PagedRequest, io.atlassian.fugue.Either<AnError, ReportDrillDownPagedData>> drillDownExportPageRetriever = this.reportDrillDownService.getDrillDownExportPageRetriever(user.forJIRA(), project, timescale, seriesId);
        return Steps.begin((io.atlassian.fugue.Either)this.seriesService.getSeries(user, project, seriesId.longValue())).then(series -> io.atlassian.fugue.Either.right((Object)this.reportExportFileStreamHelper.getDrillDownCsvStream(user, (Series)series, serviceDesk, drillDownExportPageRetriever))).then((series, csvStream) -> this.customReportService.getReport(user.forJIRA(), project, serviceDesk, series.getReportId().toString())).then((series, csvStream, report) -> this.generateDrilldownFilename(user, report.getName(), timescale, date, series.getLabel())).yield((series, csvStream, report, filename) -> this.createCsvResponseFromStream((StreamingOutput)csvStream, (String)filename));
    }

    private io.atlassian.fugue.Either<AnError, String> generateDrilldownFilename(CheckedUser user, String reportName, Timescale timescale, Long startdate, String seriesLabel) {
        DateTimeZone userDateTimeZone = this.userTimeZoneService.getUserDateTimeZone(user.forJIRA());
        String summaryString = user.i18NHelper().getText("sd.reports.reports.export.filename.summary.label");
        ReportExportFilenameGenerator reportExportFilenameGenerator = new ReportExportFilenameGenerator(reportName, timescale, userDateTimeZone, summaryString, (Option<String>)Option.some((Object)seriesLabel));
        DateTime startTime = new DateTime((Object)startdate, userDateTimeZone);
        DateTime endTime = startTime.plus((ReadablePeriod)timescale.getTimeBreakdown().getPeriod());
        return io.atlassian.fugue.Either.right((Object)reportExportFilenameGenerator.generate(startTime.toInstant().getMillis(), endTime.toInstant().getMillis()));
    }

    protected io.atlassian.fugue.Either<AnError, ReportTimescale> getReportTimeScale(Long timescaleId) {
        if (timescaleId == null) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.badRequest400("sd.project.reports.timescale.missing", new Object[0]).build());
        }
        ReportTimescale timescale = this.reportTimescaleManager.getTimescale(timescaleId.longValue());
        if (timescale == null) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.badRequest400("sd.project.reports.timeperiod.invalid", new Object[]{timescaleId}).build());
        }
        return io.atlassian.fugue.Either.right((Object)timescale);
    }

    private io.atlassian.fugue.Either<AnError, Timescale> getTimescaleFromId(Long date, Long timescaleId) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.reportTimescaleConversionHelper.convertFromTimescaleId(timescaleId, new DateTime((Object)date), this.userTimeZoneService.getUserDateTimeZone(user.forJIRA()))).yield((user, result) -> result);
    }

    @GET
    @Path(value="/report/predefined/{reportId}/csv")
    public Response getPredefinedReportSummaryExportCSV(@PathParam(value="projectKey") String projectKey, @PathParam(value="reportId") String reportId, @QueryParam(value="timescaleId") Long timescaleId) {
        return (Response)Eithers.merge((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalServiceDeskService.getServiceDeskForKey(user, projectKey, false)).then((user, serviceDesk) -> this.getTimescaleAsEither(timescaleId)).then((user, serviceDesk, timescale) -> PredefinedReport.fromId(reportId).toRight(() -> this.errorResultHelper.notFound404("sd.report.error.missing", new Object[0]).build())).then((user, serviceDesk, timescale, report) -> this.createPredefinedReportSummaryCsv((CheckedUser)user, (ServiceDesk)serviceDesk, (PredefinedReport)((Object)report), (Timescale)timescale)).yield((user, serviceDesk, timescale, report, csvResponse) -> csvResponse).leftMap(error -> this.restResponseHelper.anErrorToResponse(error)));
    }

    @GET
    @Path(value="/report/{reportId}/csv")
    public Response getCustomReportSummaryExportCSV(@PathParam(value="projectKey") String projectKey, @PathParam(value="reportId") String reportId, @QueryParam(value="timescaleId") Long timescaleId) {
        return (Response)Eithers.merge((io.atlassian.fugue.Either)Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.getProject(projectKey)).then((user, project) -> this.internalServiceDeskService.getServiceDeskForProject(user, project, false)).then((user, project, serviceDesk) -> this.getTimescaleAsEither(timescaleId)).then((user, project, serviceDesk, timescale) -> this.createSummaryCsv((CheckedUser)user, (Project)project, reportId, (Timescale)timescale, (ServiceDesk)serviceDesk)).yield((user, project, serviceDesk, timescale, csvResponse) -> csvResponse).leftMap(error -> this.restResponseHelper.anErrorToResponse(error)));
    }

    private io.atlassian.fugue.Either<AnError, Timescale> getTimescaleAsEither(Long timescaleId) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.getReportTimeScale(timescaleId)).then((user, reportTimescale) -> this.reportTimescaleConversionHelper.convertFromReportTimescale((ReportTimescale)reportTimescale, DateTime.now(), this.userTimeZoneService.getUserDateTimeZone(user.forJIRA())).toRight(() -> this.errorResultHelper.badRequest400("sd.project.reports.timeperiod.invalid", new Object[0]).build())).yield((user, reportTimescale, result) -> result);
    }

    private io.atlassian.fugue.Either<AnError, Response> createPredefinedReportSummaryCsv(CheckedUser user, ServiceDesk serviceDesk, PredefinedReport report, Timescale timescale) {
        return Steps.begin(this.reportService.getReport(user.forJIRA(), report.getId(), serviceDesk, timescale)).then(reportData -> io.atlassian.fugue.Either.right((Object)this.reportExportFileStreamHelper.convertSummaryDataToCsvStream(user, (ReportDataResponse)reportData, timescale))).then((reportData, csvStream) -> this.generateSummaryFilename(user, report.getId(), timescale)).yield((reportData, csvStream, filename) -> this.createCsvResponseFromStream((StreamingOutput)csvStream, (String)filename));
    }

    private io.atlassian.fugue.Either<AnError, Response> createSummaryCsv(CheckedUser user, Project project, String reportId, Timescale timescale, ServiceDesk serviceDesk) {
        return Steps.begin((io.atlassian.fugue.Either)this.customReportService.getReport(user.forJIRA(), project, serviceDesk, reportId)).then(report -> this.customReportDataService.getReportDataFromReportId(user.forJIRA(), project, serviceDesk, reportId, timescale)).then((report, summaryData) -> io.atlassian.fugue.Either.right((Object)this.reportExportFileStreamHelper.convertSummaryDataToCsvStream(user, (List<CustomReportData>)summaryData, timescale))).then((report, summaryData, csvStream) -> this.generateSummaryFilename(user, report.getName(), timescale)).yield((report, summaryData, csvStream, filename) -> this.createCsvResponseFromStream((StreamingOutput)csvStream, (String)filename));
    }

    private Response createCsvResponseFromStream(StreamingOutput csvStream, String filename) {
        return Response.ok((Object)csvStream).type("text/csv").header("Content-Disposition", (Object)String.format("attachment; filename=%s.csv", filename)).build();
    }

    private io.atlassian.fugue.Either<AnError, String> generateSummaryFilename(CheckedUser user, String reportName, Timescale timescale) {
        DateTimeZone userDateTimeZone = this.userTimeZoneService.getUserDateTimeZone(user.forJIRA());
        String summaryString = this.i18nHelper.getText("sd.reports.reports.export.filename.summary.label");
        ReportExportFilenameGenerator reportExportFilenameGenerator = new ReportExportFilenameGenerator(reportName, timescale, userDateTimeZone, summaryString, (Option<String>)Option.none());
        return io.atlassian.fugue.Either.right((Object)reportExportFilenameGenerator.generate(timescale.getStartTime().toInstant().getMillis(), timescale.getEndTime().toInstant().getMillis()));
    }
}

