/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.onboarding.OnBoardingPropertiesService;
import com.atlassian.servicedesk.internal.api.report.AddOrEditReportRequest;
import com.atlassian.servicedesk.internal.api.report.CustomReportService;
import com.atlassian.servicedesk.internal.api.report.Report;
import com.atlassian.servicedesk.internal.api.report.ReportBulkSaveRequest;
import com.atlassian.servicedesk.internal.api.report.ReportTimescale;
import com.atlassian.servicedesk.internal.api.report.ReportTimescaleManager;
import com.atlassian.servicedesk.internal.api.report.Series;
import com.atlassian.servicedesk.internal.api.report.series.SeriesService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.plugins.reports.internal.helper.ReportTimescaleConversionHelper;
import com.atlassian.servicedesk.plugins.reports.internal.reportdata.CustomReportData;
import com.atlassian.servicedesk.plugins.reports.internal.reportdata.CustomReportDataService;
import com.atlassian.servicedesk.plugins.reports.internal.rest.ReportsBaseResource;
import com.atlassian.servicedesk.plugins.reports.internal.rest.response.ReportDataResponse;
import com.atlassian.servicedesk.plugins.reports.internal.rest.response.ReportSeriesResponse;
import com.atlassian.servicedesk.plugins.reports.internal.series.Point;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.Timescale;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.UserTimeZoneService;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;

@Path(value="servicedesk/{projectKey}/report")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ReportResource
extends ReportsBaseResource {
    private static final Logger LOG = Logger.getLogger(ReportResource.class);
    private static final long NO_VALUE = -1L;
    private final UserFactory userFactory;
    private final CustomReportService customReportService;
    private final InternalServiceDeskService internalServiceDeskService;
    private final CustomReportDataService customReportDataService;
    private final SeriesService seriesService;
    private final ReportTimescaleManager reportTimescaleManager;
    private final OnBoardingPropertiesService onBoardingPropertiesService;
    private final RestResponseHelper restResponseHelper;
    private final ReportTimescaleConversionHelper reportTimescaleConversionHelper;
    private final UserTimeZoneService userTimeZoneService;

    public ReportResource(UserFactory userFactory, ProjectService projectService, CustomReportService customReportService, InternalServiceDeskService internalServiceDeskService, CustomReportDataService customReportDataService, SeriesService seriesService, ReportTimescaleManager reportTimescaleManager, OnBoardingPropertiesService onBoardingPropertiesService, RestResponseHelper restResponseHelper, ReportTimescaleConversionHelper reportTimescaleConversionHelper, UserTimeZoneService userTimeZoneService) {
        super(projectService);
        this.userFactory = userFactory;
        this.customReportService = customReportService;
        this.internalServiceDeskService = internalServiceDeskService;
        this.customReportDataService = customReportDataService;
        this.seriesService = seriesService;
        this.reportTimescaleManager = reportTimescaleManager;
        this.onBoardingPropertiesService = onBoardingPropertiesService;
        this.restResponseHelper = restResponseHelper;
        this.reportTimescaleConversionHelper = reportTimescaleConversionHelper;
        this.userTimeZoneService = userTimeZoneService;
    }

    @POST
    @Path(value="/new")
    public Response createReport(@PathParam(value="projectKey") String projectKey, @QueryParam(value="timescaleId") String timescaleId, AddOrEditReportRequest request) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.getProject(projectKey)).then((checkedUser, project) -> this.internalServiceDeskService.getServiceDeskForProject(checkedUser, project, false)).then((checkedUser, project, sd) -> this.seriesService.validateSeriesAndType(checkedUser, project, -1L, request.getSeries())).then((checkedUser, project, sd, seriesList) -> this.customReportService.createReport(checkedUser, project, sd, Option.option((Object)request.getName()), seriesList, Option.option((Object)request.getTarget()))).yield((checkedUser, project, sd, seriesList, report) -> report);
        io.atlassian.fugue.Either convertedResponse = result.map(this::convertReportIntoResponse);
        return this.restResponseHelper.anErrorEitherToOkResponse(convertedResponse);
    }

    @PUT
    public Response deleteAndSortReports(@PathParam(value="projectKey") String projectKey, ReportBulkSaveRequest request) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.getProject(projectKey)).then((checkedUser, project) -> this.internalServiceDeskService.getServiceDeskForProject(checkedUser, project, false)).then((checkedUser, project, sd) -> this.doDeleteAndSort((CheckedUser)checkedUser, (Project)project, (ServiceDesk)sd, request)).yield((checkedUser, project, sd, reportList) -> reportList);
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private io.atlassian.fugue.Either<AnError, List<Report>> doDeleteAndSort(CheckedUser user, Project project, ServiceDesk serviceDesk, ReportBulkSaveRequest request) {
        return Steps.begin(this.deleteReports(user, project, serviceDesk, request.getDeleted())).then(u1 -> this.reorderReports(user, serviceDesk, request.getOrder())).then((u1, u2) -> this.customReportService.getAllVisibleReports(user, serviceDesk)).yield((u1, u2, reports) -> reports);
    }

    private io.atlassian.fugue.Either<AnError, Unit> deleteReports(CheckedUser user, Project project, ServiceDesk serviceDesk, List<Long> deleted) {
        for (Long l : deleted) {
            io.atlassian.fugue.Either result = this.customReportService.deleteReport(user, project, serviceDesk, l);
            if (!result.isLeft()) continue;
            return result.map(r -> Unit.Unit());
        }
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    private io.atlassian.fugue.Either<AnError, Unit> reorderReports(CheckedUser user, ServiceDesk serviceDesk, List<Long> order) {
        for (int i = 0; i < order.size(); ++i) {
            Long toSort = order.get(i);
            Long afterId = i == 0 ? Long.valueOf(-1L) : order.get(i - 1);
            io.atlassian.fugue.Either result = this.customReportService.reorderReport(user, serviceDesk, Option.option((Object)toSort), Option.option((Object)afterId));
            if (!result.isLeft()) continue;
            return result.map(r -> Unit.Unit());
        }
        return io.atlassian.fugue.Either.right((Object)Unit.Unit());
    }

    @PUT
    @Path(value="/{reportId}")
    public Response saveReport(@PathParam(value="projectKey") String projectKey, @PathParam(value="reportId") String rawReportId, @QueryParam(value="timescaleId") String timescaleId, AddOrEditReportRequest request) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.getProject(projectKey)).then((checkedUser, project) -> this.internalServiceDeskService.getServiceDeskForProject(checkedUser, project, false)).then((checkedUser, project, sd) -> this.seriesService.validateSeriesAndType(checkedUser, project, -1L, request.getSeries())).then((checkedUser, project, sd, validatedSeries) -> this.saveReportAndSeries((CheckedUser)checkedUser, (Project)project, (ServiceDesk)sd, rawReportId, request)).yield((checkedUser, project, sd, validatedSeries, report) -> report);
        io.atlassian.fugue.Either convertedResponse = result.map(this::convertReportIntoResponse);
        return this.restResponseHelper.anErrorEitherToOkResponse(convertedResponse);
    }

    private io.atlassian.fugue.Either<AnError, Report> saveReportAndSeries(CheckedUser checkedUser, Project project, ServiceDesk sd, String rawReportId, AddOrEditReportRequest request) {
        return Steps.begin((io.atlassian.fugue.Either)this.seriesService.validateSeriesAndType(checkedUser, project, (long)Integer.parseInt(rawReportId), request.getSeries())).then(validatedSeries -> this.customReportService.updateReport(checkedUser, project, sd, rawReportId, Option.option((Object)request.getName()), Option.option((Object)request.getTarget()), validatedSeries)).then((validatedSeries, report) -> this.seriesService.bulkSaveSeries(checkedUser, project, sd, report, request.getSeries())).then((validatedSeries, report, unit) -> this.customReportService.getReport(checkedUser.forJIRA(), project, sd, rawReportId)).yield((validatedSeries, report, unit, postUpdateReport) -> postUpdateReport);
    }

    @GET
    @Path(value="/{reportId}")
    public Response getReportData(@PathParam(value="projectKey") String projectKey, @PathParam(value="reportId") String reportId, @QueryParam(value="timescaleId") String timescaleId) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.getProject(projectKey)).then((checkedUser, project) -> this.internalServiceDeskService.getServiceDeskForProject(checkedUser, project, false)).then((checkedUser, project, sd) -> this.customReportService.getReport(checkedUser.forJIRA(), project, sd, reportId)).yield((checkedUser, project, sd, report) -> this.getReportDataHelper((CheckedUser)checkedUser, (ServiceDesk)sd, timescaleId, (Report)report, report.getSeries(), report.getTarget()));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @PUT
    @Path(value="/{reportId}/validate")
    public Response validateEdit(@PathParam(value="projectKey") String projectKey, @PathParam(value="reportId") String reportId, @QueryParam(value="timescaleId") String timescaleId, AddOrEditReportRequest request) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.getProject(projectKey)).then((checkedUser, project) -> this.internalServiceDeskService.getServiceDeskForProject(checkedUser, project, false)).then((checkedUser, project, sd) -> this.customReportService.getReport(checkedUser.forJIRA(), project, sd, reportId)).then((checkedUser, project, sd, report) -> this.validateReportAndSeriesForEdit(request, (CheckedUser)checkedUser, (Project)project, (Report)report)).yield((checkedUser, project, sd, report, validatedSeriesList) -> this.getReportDataHelper((CheckedUser)checkedUser, (ServiceDesk)sd, timescaleId, (Report)report, (List<Series>)validatedSeriesList, request.getTarget()));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private io.atlassian.fugue.Either<AnError, List<Series>> validateReportAndSeriesForEdit(AddOrEditReportRequest request, CheckedUser checkedUser, Project project, Report report) {
        return Steps.begin((io.atlassian.fugue.Either)this.customReportService.validateReportName(Option.option((Object)request.getName()))).then(reportName -> this.seriesService.validateSeriesAndType(checkedUser, project, report.getId().longValue(), request.getSeries())).then((reportName, seriesList) -> this.customReportService.validateTarget(Option.option((Object)request.getTarget()), seriesList)).yield((reportName, seriesList, target) -> seriesList);
    }

    @PUT
    @Path(value="/new/validate")
    public Response validateCreate(@PathParam(value="projectKey") String projectKey, @QueryParam(value="timescaleId") String timescaleId, AddOrEditReportRequest request) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.getProject(projectKey)).then((checkedUser, project) -> this.internalServiceDeskService.getServiceDeskForProject(checkedUser, project, false)).then((checkedUser, project, sd) -> this.seriesService.validateSeriesAndType(checkedUser, project, -1L, request.getSeries())).then((checkedUser, project, sd, seriesList) -> this.customReportService.validateTarget(Option.option((Object)request.getTarget()), seriesList)).yield((checkedUser, project, sd, seriesList, target) -> {
            Report fakeReport = new Report(Long.valueOf(-1L), Long.valueOf(sd.getId()), "", Option.some((Object)"sd.report.type.line.graph.count"), Integer.valueOf(0), seriesList, target);
            return this.getReportDataHelper((CheckedUser)checkedUser, (ServiceDesk)sd, timescaleId, fakeReport, (List<Series>)seriesList, (Long)target);
        });
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private ReportDataResponse convertReportIntoResponse(Report report) {
        ReportDataResponse result = new ReportDataResponse(String.valueOf(report.getId()), new ArrayList<ReportSeriesResponse>(report.getSeries().size()), report.getName(), false, report.getTarget());
        for (Series series : report.getSeries()) {
            ReportSeriesResponse.Builder builder = ReportSeriesResponse.builder().withSeriesId(String.valueOf(series.getId())).withReportId(series.getReportId()).withLabel(series.getLabel()).withJql(series.getJql()).withColor(series.getColor()).withSeriesType(series.getSeriesType());
            if (series.getTimeMetricIdOption().isDefined()) {
                builder = builder.withTimeMetricId(series.getTimeMetricId()).withTimeMetricIdOption(String.valueOf(series.getTimeMetricId()));
            }
            if (series.getGoalIdOption().isDefined()) {
                builder = builder.withGoalId(series.getGoalId());
            }
            result.getSeries().add(builder.build());
        }
        return result;
    }

    private ReportDataResponse getReportDataHelper(CheckedUser user, ServiceDesk sd, String timescaleId, Report report, List<Series> seriesList, Long target) {
        Option<Timescale> timescale = this.reportTimescaleConversionHelper.convertFromReportTimescale(this.getTimescale(timescaleId), DateTime.now(), this.userTimeZoneService.getUserDateTimeZone(user.forJIRA()));
        List<CustomReportData> dataList = this.customReportDataService.getReportDataForSeries(user, sd, seriesList, (Timescale)timescale.get());
        boolean expandHelpBubble = this.onBoardingPropertiesService.shouldExpandAdminAgentHelpBubble("local.servicedesk.help.bubble.custom.reports.page.shown", user.forJIRA(), sd);
        if (expandHelpBubble) {
            this.onBoardingPropertiesService.dismissAdminAgentHelpBubble("local.servicedesk.help.bubble.custom.reports.page.shown", user.forJIRA(), sd);
        }
        ReportDataResponse result = new ReportDataResponse(String.valueOf(report.getId()), new ArrayList<ReportSeriesResponse>(seriesList.size()), report.getName(), expandHelpBubble, target);
        for (int loop = 0; loop < seriesList.size(); ++loop) {
            Series series = seriesList.get(loop);
            CustomReportData data = dataList.get(loop);
            this.buildAndAddReportSeriesResponse(report, series, data, result);
        }
        return result;
    }

    private void buildAndAddReportSeriesResponse(Report report, Series series, CustomReportData data, ReportDataResponse result) {
        if (series.getSeriesType() != null) {
            ReportSeriesResponse.Builder builder = ReportSeriesResponse.builder().withReportId(report.getId()).withSeriesId(String.valueOf(series.getId())).withData(data.getData().stream().map(Point::new).collect(Collectors.toList())).withLabel(series.getLabel()).withYAxisType(data.getYaxis().getStringFormat()).withColor(series.getColor()).withJql(series.getJql()).withSeriesKey(series.getSeriesType().getTypeKey()).withSeriesType(series.getSeriesType()).withTimeMetricId(series.getTimeMetricId()).withSummaryValue(data.getStatistic());
            if (!series.getTimeMetricIdOption().isEmpty()) {
                builder = builder.withTimeMetricIdOption(String.valueOf(series.getTimeMetricIdOption().get()));
            }
            if (series.getGoalId() != null) {
                builder = builder.withGoalId(series.getGoalId());
            }
            result.getSeries().add(builder.build());
        } else {
            LOG.warn((Object)("Ignoring a series with an unknown seriesType that has " + data.getData().size() + " point(s)"));
        }
    }

    private ReportTimescale getTimescale(String timescaleIdStr) {
        ReportTimescale defaultTimescale = this.reportTimescaleManager.getDefaultTimescale();
        try {
            Long timescaleId = Long.valueOf(timescaleIdStr);
            ReportTimescale timescale = this.reportTimescaleManager.getTimescale(timescaleId.longValue());
            return (ReportTimescale)Option.option((Object)timescale).getOrElse((Object)defaultTimescale);
        }
        catch (NumberFormatException n) {
            return defaultTimescale;
        }
    }
}

