/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.reportdata.calculator.lookup;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.jira.plugins.workinghours.api.calculator.WorkingHoursCalculator;
import com.atlassian.servicedesk.internal.api.sla.metric.CalculatorLookup;
import io.atlassian.fugue.Option;
import java.util.Map;

@TenantAware(value=TenancyScope.TENANTED)
public class CalculatorLookupImpl
implements CalculatorLookup {
    private final Map<Long, WorkingHoursCalculator> issueIdToCalculator;
    private final WorkingHoursCalculator defaultCalculator;

    public CalculatorLookupImpl(Map<Long, WorkingHoursCalculator> issueIdToCalculator, WorkingHoursCalculator defaultCalculator) {
        this.issueIdToCalculator = issueIdToCalculator;
        this.defaultCalculator = defaultCalculator;
    }

    public WorkingHoursCalculator getCalculatorForIssue(Long issueId) {
        return (WorkingHoursCalculator)Option.option((Object)this.issueIdToCalculator.get(issueId)).getOrElse((Object)this.defaultCalculator);
    }
}

