/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.reportdata;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.annotations.lucene.LuceneUsage;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.search.issue.callback.DataCallback;
import com.atlassian.pocketknife.api.search.issue.service.IssueDataService;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.sla.metrics.TimeMetric;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.customfields.feedback.RequestFeedbackCFManager;
import com.atlassian.servicedesk.internal.api.customfields.feedback.RequestFeedbackDateCFManager;
import com.atlassian.servicedesk.internal.api.feedback.FeedbackReportQueryBuilderFactory;
import com.atlassian.servicedesk.internal.api.report.CustomReportService;
import com.atlassian.servicedesk.internal.api.report.Report;
import com.atlassian.servicedesk.internal.api.report.Series;
import com.atlassian.servicedesk.internal.api.report.series.SeriesDataTypeKeys;
import com.atlassian.servicedesk.internal.api.sla.SLAAccessorService;
import com.atlassian.servicedesk.internal.api.sla.metric.CalculatorLookup;
import com.atlassian.servicedesk.internal.api.sla.metric.SLALuceneDocumentDataManager;
import com.atlassian.servicedesk.internal.api.sla.searcher.builder.SlaQueryBuilderFactory;
import com.atlassian.servicedesk.internal.api.user.ServiceDeskUserTimeZoneService;
import com.atlassian.servicedesk.plugins.reports.internal.collector.AverageCollector;
import com.atlassian.servicedesk.plugins.reports.internal.collector.CountCollector;
import com.atlassian.servicedesk.plugins.reports.internal.collector.DataCollector;
import com.atlassian.servicedesk.plugins.reports.internal.collector.DurationCollector;
import com.atlassian.servicedesk.plugins.reports.internal.collector.NoOpCollector;
import com.atlassian.servicedesk.plugins.reports.internal.collector.callback.CollectedIssue;
import com.atlassian.servicedesk.plugins.reports.internal.collector.callback.IssueCallBack;
import com.atlassian.servicedesk.plugins.reports.internal.collector.callback.MultiFieldCallback;
import com.atlassian.servicedesk.plugins.reports.internal.collector.input.DateTimeValue;
import com.atlassian.servicedesk.plugins.reports.internal.collector.result.DataCollectorResult;
import com.atlassian.servicedesk.plugins.reports.internal.collector.translator.AverageRatingTranslator;
import com.atlassian.servicedesk.plugins.reports.internal.collector.translator.DateLuceneTranslator;
import com.atlassian.servicedesk.plugins.reports.internal.collector.translator.LuceneTranslator;
import com.atlassian.servicedesk.plugins.reports.internal.collector.translator.NoOpLuceneTranslator;
import com.atlassian.servicedesk.plugins.reports.internal.collector.translator.TimeMetricCountTranslator;
import com.atlassian.servicedesk.plugins.reports.internal.collector.translator.TimeMetricDurationTranslator;
import com.atlassian.servicedesk.plugins.reports.internal.model.YAxisType;
import com.atlassian.servicedesk.plugins.reports.internal.reportdata.CustomReportData;
import com.atlassian.servicedesk.plugins.reports.internal.reportdata.CustomReportDataService;
import com.atlassian.servicedesk.plugins.reports.internal.reportdata.PercentageUtils;
import com.atlassian.servicedesk.plugins.reports.internal.reportdata.ReportQueries;
import com.atlassian.servicedesk.plugins.reports.internal.reportdata.calculator.lookup.CalculatorLookupService;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.TimeBreakdown;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.Timescale;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.lucene.search.Query;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomReportDataServiceImpl
implements CustomReportDataService {
    private final UserFactory userFactory;
    private final IssueDataService issueDataService;
    private final SLAAccessorService slaAccessorService;
    private final SlaQueryBuilderFactory slaQueryBuilderFactory;
    private final SLALuceneDocumentDataManager slaLuceneDocumentDataManager;
    private final SearchService searchService;
    private final CustomReportService reportService;
    private final ServiceDeskUserTimeZoneService serviceDeskUserTimeZoneService;
    private final CalculatorLookupService calculatorLookupService;
    private final ReportQueries reportQueries;
    private final RequestFeedbackCFManager requestFeedbackCFManager;
    private final RequestFeedbackDateCFManager requestFeedbackDateCFManager;
    private final FeedbackReportQueryBuilderFactory feedbackReportQueryBuilderFactory;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public CustomReportDataServiceImpl(UserFactory userFactory, ReportQueries reportQueries, IssueDataService issueDataService, SLAAccessorService slaAccessorService, CalculatorLookupService calculatorLookupService, SlaQueryBuilderFactory slaQueryBuilderFactory, SLALuceneDocumentDataManager slaLuceneDocumentDataManager, SearchService searchService, CustomReportService reportService, ServiceDeskUserTimeZoneService serviceDeskUserTimeZoneService, RequestFeedbackCFManager requestFeedbackCFManager, RequestFeedbackDateCFManager requestFeedbackDateCFManager, FeedbackReportQueryBuilderFactory feedbackReportQueryBuilderFactory, ErrorResultHelper errorResultHelper) {
        this.userFactory = userFactory;
        this.reportQueries = reportQueries;
        this.issueDataService = issueDataService;
        this.slaAccessorService = slaAccessorService;
        this.calculatorLookupService = calculatorLookupService;
        this.slaQueryBuilderFactory = slaQueryBuilderFactory;
        this.slaLuceneDocumentDataManager = slaLuceneDocumentDataManager;
        this.searchService = searchService;
        this.reportService = reportService;
        this.serviceDeskUserTimeZoneService = serviceDeskUserTimeZoneService;
        this.requestFeedbackCFManager = requestFeedbackCFManager;
        this.requestFeedbackDateCFManager = requestFeedbackDateCFManager;
        this.feedbackReportQueryBuilderFactory = feedbackReportQueryBuilderFactory;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<CustomReportData>> getReportDataFromReportId(ApplicationUser user, Project project, ServiceDesk sd, String id, Timescale timescale) {
        return Steps.begin((io.atlassian.fugue.Either)this.reportService.getReport(user, project, sd, id)).then(report -> this.getReportData(user, sd, (Report)report, timescale)).yield((report, reportData) -> reportData);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<CustomReportData>> getReportData(ApplicationUser user, ServiceDesk sd, Report report, Timescale timescale) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(user))).yield(checkedUser -> this.getReportDataForSeries((CheckedUser)checkedUser, sd, report.getSeries(), timescale));
    }

    @Override
    public List<CustomReportData> getReportDataForSeries(CheckedUser user, ServiceDesk sd, List<Series> seriesList, Timescale timescale) {
        TimeZone zone = this.serviceDeskUserTimeZoneService.getUserTimeZone(user);
        DateTimeZone userTimezone = DateTimeZone.forTimeZone((TimeZone)zone);
        DateTime endDate = DateTime.now((DateTimeZone)userTimezone).plusMinutes(5);
        return seriesList.stream().map(series -> this.getDataForSeries((Series)series, user, sd, timescale, userTimezone, timescale.getStartTime(), endDate)).collect(Collectors.toList());
    }

    @Override
    public Set<CollectedIssue> collectIssuesForDrilldown(Series series, CheckedUser user, ServiceDesk sd, Timescale timescale, DateTimeZone dateTimeZone) {
        Option<com.atlassian.query.Query> seriesQueryOpt = this.reportQueries.getQueryFromSeries(this.searchService, user.forJIRA(), sd, series);
        Option<Timescale> timescaleOpt = this.getDrilldownTimescale(timescale, dateTimeZone);
        Option seriesTypeEnumOption = Steps.begin((Option)Option.option((Object)series.getSeriesType())).then(seriesType -> SeriesDataTypeKeys.fromString((String)seriesType.getTypeKey())).yield((seriesType, seriesTypeKey) -> seriesTypeKey);
        if (timescaleOpt.isDefined() && seriesTypeEnumOption.isDefined()) {
            Timescale drilldownTimescale = (Timescale)timescaleOpt.get();
            switch ((SeriesDataTypeKeys)seriesTypeEnumOption.get()) {
                case CREATED_COUNT_SERIES_TYPE_KEY: {
                    DateLuceneTranslator documentBuilder = new DateLuceneTranslator("created", dateTimeZone);
                    com.atlassian.query.Query query = this.reportQueries.issueCreatedQuery(sd, drilldownTimescale.getStartTime(), drilldownTimescale.getEndTime());
                    IssueCallBack callback = this.runQuery(user, seriesQueryOpt, query, documentBuilder, drilldownTimescale, (Option<Query>)Option.none());
                    return callback.getIssues();
                }
                case RESOLVED_COUNT_SERIES_TYPE_KEY: {
                    DateLuceneTranslator documentBuilder = new DateLuceneTranslator("resolutiondate", dateTimeZone);
                    com.atlassian.query.Query query = this.reportQueries.issueResolutionDateQuery(sd, drilldownTimescale.getStartTime(), drilldownTimescale.getEndTime());
                    IssueCallBack callback = this.runQuery(user, seriesQueryOpt, query, documentBuilder, drilldownTimescale, (Option<Query>)Option.none());
                    return callback.getIssues();
                }
                case TIME_METRIC_ELAPSED_TIME_SERIES_TYPE_KEY: {
                    com.atlassian.query.Query query = this.reportQueries.timeMetricQuery(sd, drilldownTimescale.getStartTime(), drilldownTimescale.getEndTime());
                    IssueCallBack callback = (IssueCallBack)this.runTimeMetricDurationQuery(query, seriesQueryOpt, series, user, sd, drilldownTimescale, dateTimeZone, drilldownTimescale.getStartTime(), drilldownTimescale.getEndTime(), true);
                    return callback.getIssues();
                }
                case SLA_SUCCEEDED_SERIES_TYPE_KEY: {
                    Option<CustomField> cf = this.getSlaCustomField(sd, series);
                    com.atlassian.query.Query query = this.reportQueries.slaSucceededQuery(sd, drilldownTimescale.getStartTime(), drilldownTimescale.getEndTime(), cf);
                    IssueCallBack callback = (IssueCallBack)this.runTimeMetricCountQuery(query, seriesQueryOpt, series, user, sd, drilldownTimescale, dateTimeZone, drilldownTimescale.getStartTime(), drilldownTimescale.getEndTime(), true);
                    return callback.getIssues();
                }
                case SLA_BREACHED_SERIES_TYPE_KEY: {
                    Option<CustomField> cf = this.getSlaCustomField(sd, series);
                    com.atlassian.query.Query query = this.reportQueries.slaBreachedQuery(sd, drilldownTimescale.getStartTime(), drilldownTimescale.getEndTime(), cf);
                    IssueCallBack callback = (IssueCallBack)this.runTimeMetricCountQuery(query, seriesQueryOpt, series, user, sd, drilldownTimescale, dateTimeZone, drilldownTimescale.getStartTime(), drilldownTimescale.getEndTime(), true);
                    return callback.getIssues();
                }
                case AVERAGE_RATING_SERIES_TYPE_KEY: {
                    IssueCallBack callback = (IssueCallBack)this.runAverageRatingQuery(sd, seriesQueryOpt, user, drilldownTimescale, dateTimeZone, drilldownTimescale.getStartTime(), drilldownTimescale.getEndTime(), true);
                    return callback.getIssues();
                }
                case PERCENTAGE_SERIES_TYPE_KEY: {
                    Option<CustomField> cf = this.getSlaCustomField(sd, series);
                    com.atlassian.query.Query query = this.reportQueries.slaSucceededAndBreachedQuery(sd, cf);
                    IssueCallBack callback = (IssueCallBack)this.runTimeMetricCountQuery(query, seriesQueryOpt, series, user, sd, drilldownTimescale, dateTimeZone, drilldownTimescale.getStartTime(), drilldownTimescale.getEndTime(), true);
                    return callback.getIssues();
                }
            }
        }
        return ((IssueCallBack)this.getNoOpCallback(true, (Timescale)timescaleOpt.get(), -1L)).getIssues();
    }

    private CustomReportData getDataForSeries(Series series, CheckedUser user, ServiceDesk sd, Timescale timescale, DateTimeZone dateTimeZone, DateTime startDate, DateTime endDate) {
        Option<com.atlassian.query.Query> seriesQueryOpt = this.reportQueries.getQueryFromSeries(this.searchService, user.forJIRA(), sd, series);
        Option seriesTypeEnumOption = Steps.begin((Option)Option.option((Object)series.getSeriesType())).then(seriesType -> SeriesDataTypeKeys.fromString((String)seriesType.getTypeKey())).yield((seriesType, seriesTypeKey) -> seriesTypeKey);
        if (seriesTypeEnumOption.isDefined()) {
            switch ((SeriesDataTypeKeys)seriesTypeEnumOption.get()) {
                case CREATED_COUNT_SERIES_TYPE_KEY: {
                    DateLuceneTranslator documentBuilder = new DateLuceneTranslator("created", dateTimeZone);
                    com.atlassian.query.Query query = this.reportQueries.issueCreatedQuery(sd, startDate, endDate);
                    return this.issueCountQueryHelper(timescale, user, seriesQueryOpt, query, documentBuilder, series);
                }
                case RESOLVED_COUNT_SERIES_TYPE_KEY: {
                    DateLuceneTranslator documentBuilder = new DateLuceneTranslator("resolutiondate", dateTimeZone);
                    com.atlassian.query.Query query = this.reportQueries.issueResolutionDateQuery(sd, startDate, endDate);
                    return this.issueCountQueryHelper(timescale, user, seriesQueryOpt, query, documentBuilder, series);
                }
                case TIME_METRIC_ELAPSED_TIME_SERIES_TYPE_KEY: {
                    com.atlassian.query.Query query = this.reportQueries.timeMetricQuery(sd, startDate, endDate);
                    MultiFieldCallback callback = (MultiFieldCallback)this.runTimeMetricDurationQuery(query, seriesQueryOpt, series, user, sd, timescale, dateTimeZone, startDate, endDate, false);
                    Object data = callback.getMultiFieldCollector().data();
                    return this.serialize(series, YAxisType.TIME, (DataCollectorResult)data);
                }
                case SLA_SUCCEEDED_SERIES_TYPE_KEY: {
                    Option<CustomField> cf = this.getSlaCustomField(sd, series);
                    com.atlassian.query.Query query = this.reportQueries.slaSucceededQuery(sd, startDate, endDate, cf);
                    MultiFieldCallback callback = (MultiFieldCallback)this.runTimeMetricCountQuery(query, seriesQueryOpt, series, user, sd, timescale, dateTimeZone, startDate, endDate, false);
                    Object data = callback.getMultiFieldCollector().data();
                    return this.serialize(series, YAxisType.COUNT, (DataCollectorResult)data);
                }
                case SLA_BREACHED_SERIES_TYPE_KEY: {
                    Option<CustomField> cf = this.getSlaCustomField(sd, series);
                    com.atlassian.query.Query query = this.reportQueries.slaBreachedQuery(sd, startDate, endDate, cf);
                    MultiFieldCallback callback = (MultiFieldCallback)this.runTimeMetricCountQuery(query, seriesQueryOpt, series, user, sd, timescale, dateTimeZone, startDate, endDate, false);
                    Object data = callback.getMultiFieldCollector().data();
                    return this.serialize(series, YAxisType.COUNT, (DataCollectorResult)data);
                }
                case AVERAGE_RATING_SERIES_TYPE_KEY: {
                    MultiFieldCallback callback = (MultiFieldCallback)this.runAverageRatingQuery(sd, seriesQueryOpt, user, timescale, dateTimeZone, startDate, endDate, false);
                    Object data = callback.getMultiFieldCollector().data();
                    return this.serialize(series, YAxisType.STAR, (DataCollectorResult)data);
                }
                case PERCENTAGE_SERIES_TYPE_KEY: {
                    Option<CustomField> cf = this.getSlaCustomField(sd, series);
                    com.atlassian.query.Query query = this.reportQueries.slaSucceededQuery(sd, startDate, endDate, cf);
                    MultiFieldCallback callback = (MultiFieldCallback)this.runTimeMetricCountQuery(query, seriesQueryOpt, series, user, sd, timescale, dateTimeZone, startDate, endDate, false);
                    Object data = callback.getMultiFieldCollector().data();
                    com.atlassian.query.Query allSlaQuery = this.reportQueries.slaSucceededAndBreachedQuery(sd, cf);
                    MultiFieldCallback allDataCallBack = (MultiFieldCallback)this.runTimeMetricCountQuery(allSlaQuery, seriesQueryOpt, series, user, sd, timescale, dateTimeZone, startDate, endDate, false);
                    Object allData = allDataCallBack.getMultiFieldCollector().data();
                    DataCollectorResult<Double> result = PercentageUtils.calculatePercentage(data, allData);
                    return this.serialize(series, YAxisType.PERCENTAGE, result);
                }
            }
        }
        Object data = ((MultiFieldCallback)this.getNoOpCallback(false, timescale, 0)).getMultiFieldCollector().data();
        return this.serialize(series, YAxisType.STAR, (DataCollectorResult)data);
    }

    private CustomReportData issueCountQueryHelper(Timescale timescale, CheckedUser user, Option<com.atlassian.query.Query> seriesQueryOpt, com.atlassian.query.Query query, DateLuceneTranslator documentBuilder, Series series) {
        CountCollector timeCollector = new CountCollector(timescale);
        MultiFieldCallback<DateTimeValue<Long>, DataCollectorResult<Long>> callback = this.runQuery(user, seriesQueryOpt, query, documentBuilder, timeCollector, (Option<Query>)Option.none());
        DataCollectorResult<Long> data = callback.getMultiFieldCollector().data();
        return this.serialize(series, YAxisType.COUNT, data);
    }

    private <T extends Number> DataCallback getNoOpCallback(boolean isCollectingIssue, Timescale timescale, T dummyValue) {
        if (isCollectingIssue) {
            return new IssueCallBack(new NoOpLuceneTranslator(), timescale);
        }
        return new MultiFieldCallback(new NoOpLuceneTranslator(), new NoOpCollector<T>(dummyValue));
    }

    private DataCallback runTimeMetricCountQuery(com.atlassian.query.Query query, Option<com.atlassian.query.Query> seriesQueryOpt, Series series, CheckedUser user, ServiceDesk sd, Timescale timescale, DateTimeZone dateTimeZone, DateTime startDate, DateTime endDate, boolean isCollectingIssue) {
        Option<TimeMetric> timeMetricOpt = this.getTimeMetric(sd, series);
        Option<CustomField> cfOpt = this.getSlaCustomField(sd, series);
        if (cfOpt.isEmpty() || timeMetricOpt.isEmpty()) {
            return this.getNoOpCallback(isCollectingIssue, timescale, -1L);
        }
        CustomField cf = (CustomField)cfOpt.get();
        TimeMetric timeMetric = (TimeMetric)timeMetricOpt.get();
        com.atlassian.query.Query temporaryQuery = this.reportQueries.joinQueries(seriesQueryOpt, query);
        Query luceneQuery = this.reportQueries.buildTimelineEndDateLuceneQuery(cf, startDate, endDate, this.slaQueryBuilderFactory);
        CalculatorLookup calculatorLookup = this.calculatorLookupService.getCalculatorLookup(user, sd, timeMetric, temporaryQuery, luceneQuery);
        TimeMetricCountTranslator documentBuilder = new TimeMetricCountTranslator(calculatorLookup, cfOpt, dateTimeZone, this.slaLuceneDocumentDataManager);
        if (isCollectingIssue) {
            return this.runQuery(user, seriesQueryOpt, query, documentBuilder, timescale, (Option<Query>)Option.some((Object)luceneQuery));
        }
        CountCollector collector = new CountCollector(timescale);
        return this.runQuery(user, seriesQueryOpt, query, documentBuilder, collector, (Option<Query>)Option.some((Object)luceneQuery));
    }

    private DataCallback runTimeMetricDurationQuery(com.atlassian.query.Query query, Option<com.atlassian.query.Query> seriesQueryOpt, Series series, CheckedUser user, ServiceDesk sd, Timescale timescale, DateTimeZone dateTimeZone, DateTime startDate, DateTime endDate, boolean isCollectingIssue) {
        Option<TimeMetric> timeMetricOpt = this.getTimeMetric(sd, series);
        Option<CustomField> cfOpt = this.getSlaCustomField(sd, series);
        if (cfOpt.isEmpty() || timeMetricOpt.isEmpty()) {
            return this.getNoOpCallback(isCollectingIssue, timescale, -1L);
        }
        CustomField cf = (CustomField)cfOpt.get();
        TimeMetric timeMetric = (TimeMetric)timeMetricOpt.get();
        com.atlassian.query.Query temporaryQuery = this.reportQueries.joinQueries(seriesQueryOpt, query);
        Query luceneQuery = this.reportQueries.buildTimelineEndDateLuceneQuery(cf, startDate, endDate, this.slaQueryBuilderFactory);
        CalculatorLookup calculatorLookup = this.calculatorLookupService.getCalculatorLookup(user, sd, timeMetric, temporaryQuery, luceneQuery);
        TimeMetricDurationTranslator documentBuilder = new TimeMetricDurationTranslator(calculatorLookup, cfOpt, dateTimeZone, this.slaLuceneDocumentDataManager);
        if (isCollectingIssue) {
            return this.runQuery(user, seriesQueryOpt, query, documentBuilder, timescale, (Option<Query>)Option.some((Object)luceneQuery));
        }
        DurationCollector collector = new DurationCollector(timescale);
        return this.runQuery(user, seriesQueryOpt, query, documentBuilder, collector, (Option<Query>)Option.some((Object)luceneQuery));
    }

    private DataCallback runAverageRatingQuery(ServiceDesk serviceDesk, Option<com.atlassian.query.Query> seriesQueryOpt, CheckedUser user, Timescale timescale, DateTimeZone dateTimeZone, DateTime startDate, DateTime endDate, boolean isCollectingIssue) {
        Option cfOpt = this.requestFeedbackCFManager.getOrCreateRequestFeedbackCF();
        Option cfDateOpt = this.requestFeedbackDateCFManager.getOrCreateRequestFeedbackDateCF();
        if (cfOpt.isEmpty() || cfDateOpt.isEmpty()) {
            return this.getNoOpCallback(isCollectingIssue, timescale, 0.0);
        }
        CustomField cf = (CustomField)cfOpt.get();
        CustomField cfDate = (CustomField)cfDateOpt.get();
        com.atlassian.query.Query query = this.feedbackReportQueryBuilderFactory.createBuilder().serviceDesk(serviceDesk).startDate(startDate.toDate()).endDate(endDate.toDate()).build().buildJqlQuery(cf, cfDate);
        AverageRatingTranslator documentBuilder = new AverageRatingTranslator(cf, cfDate, dateTimeZone);
        if (isCollectingIssue) {
            return this.runQuery(user, seriesQueryOpt, query, documentBuilder, timescale, (Option<Query>)Option.none());
        }
        AverageCollector averageCollector = new AverageCollector(timescale);
        return this.runQuery(user, seriesQueryOpt, query, documentBuilder, averageCollector, (Option<Query>)Option.none());
    }

    private Option<CustomField> getSlaCustomField(ServiceDesk sd, Series series) {
        return Steps.begin(this.getTimeMetric(sd, series)).then(arg_0 -> ((SLAAccessorService)this.slaAccessorService).getSlaCustomField(arg_0)).yield((timeMetric, cf) -> cf);
    }

    private Option<TimeMetric> getTimeMetric(ServiceDesk sd, Series series) {
        return Steps.begin((Option)series.getTimeMetricIdOption()).then(timeMetricId -> this.slaAccessorService.getTimeMetric(sd, timeMetricId.intValue())).yield((timeMetricId, timeMetric) -> timeMetric);
    }

    private <T extends Number> CustomReportData serialize(Series series, YAxisType yaxis, DataCollectorResult<T> data) {
        List<List<Number>> mappedData = data.getIntervalValues().stream().map(interval -> {
            long x = interval.getInterval().getStartMillis();
            Number y = (Number)interval.getValue();
            return Lists.newArrayList((Object[])new Number[]{x, y});
        }).collect(Collectors.toList());
        String seriesTypeKey = "";
        if (series.getSeriesType() != null) {
            seriesTypeKey = series.getSeriesType().getTypeKey();
        }
        return new CustomReportData(series.getId(), series.getLabel(), seriesTypeKey, series.getColor(), (Number)data.getSeriesSummaryValue(), yaxis, mappedData);
    }

    @LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueAggregation)
    private <A, B extends DataCollectorResult> MultiFieldCallback<A, B> runQuery(CheckedUser user, Option<com.atlassian.query.Query> seriesQueryOpt, com.atlassian.query.Query reportQuery, LuceneTranslator<A> documentBuilder, DataCollector<A, B> multiFieldCollector, Option<Query> luceneQuery) {
        MultiFieldCallback<A, B> callback = new MultiFieldCallback<A, B>(documentBuilder, multiFieldCollector);
        com.atlassian.query.Query query = this.reportQueries.joinQueries(seriesQueryOpt, reportQuery);
        if (luceneQuery.isDefined()) {
            this.issueDataService.find(user.forJIRA(), query, callback, (Query)luceneQuery.get());
        } else {
            this.issueDataService.find(user.forJIRA(), query, callback);
        }
        return callback;
    }

    @LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueAggregation)
    private <A extends Number, B extends DateTimeValue<A>> IssueCallBack<A, B> runQuery(CheckedUser user, Option<com.atlassian.query.Query> seriesQueryOpt, com.atlassian.query.Query reportQuery, LuceneTranslator<B> documentBuilder, Timescale timescale, Option<Query> luceneQuery) {
        IssueCallBack callback = new IssueCallBack(documentBuilder, timescale);
        com.atlassian.query.Query query = this.reportQueries.joinQueries(seriesQueryOpt, reportQuery);
        if (luceneQuery.isDefined()) {
            this.issueDataService.find(user.forJIRA(), query, callback, (Query)luceneQuery.get());
        } else {
            this.issueDataService.find(user.forJIRA(), query, callback);
        }
        return callback;
    }

    private Option<Timescale> getDrilldownTimescale(Timescale timescale, DateTimeZone dateTimeZone) {
        TimeBreakdown timeBreakdown = timescale.getTimeBreakdown();
        return Steps.begin((Option)Timescale.createTimescale(timeBreakdown.getPeriod().multipliedBy(2), timeBreakdown, timescale.getEndTime().plus(timescale.getTimeIntervals().get(0).toDuration().getMillis()).getMillis(), dateTimeZone, this.errorResultHelper).right().toOption()).yield(drilldownTimescale -> drilldownTimescale);
    }
}

