/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.model;

import com.atlassian.servicedesk.plugins.reports.internal.i18n.CommonI18n;
import com.atlassian.servicedesk.plugins.reports.internal.model.SeriesColor;
import com.atlassian.servicedesk.plugins.reports.internal.model.YAxisType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;

public enum PredefinedReportSeries {
    KB_ARTICLE_VIEWS_SERIES("kb-article-views", SeriesColor.ADG_BLUE, "sd.project.reports.kb.usage.article.views", YAxisType.COUNT),
    KB_HELPFUL_SERIES("kb-helpful", SeriesColor.ADG_LIME_GREEN, "sd.project.reports.kb.usage.people.helped", YAxisType.COUNT),
    KB_SOLVED_BY_SELF_SERVICE_SERIES("kb-solved-by-self-service", SeriesColor.ADG_LIME_GREEN, "sd.project.reports.kb.by.self.service", YAxisType.COUNT),
    REQUEST_CREATED_SERIES("request-created", SeriesColor.ADG_RED, "sd.project.reports.kb.effectiveness.request.created", YAxisType.COUNT),
    NEW_KB_SOLVED_BY_SELF_SERVICE_SERIES("new-kb-solved-by-self-service", SeriesColor.ADG_LIME_GREEN, "sd.project.reports.kb.by.self.service", YAxisType.COUNT, (List<String>)ImmutableList.of((Object)"sd.project.reports.drilldown.kb.article", (Object)"sd.project.reports.drilldown.kb.solved.by.self.service", (Object)"sd.project.reports.drilldown.kb.views", (Object)"sd.project.reports.drilldown.kb.created.by", (Object)"sd.project.reports.drilldown.kb.last.modified")),
    NEW_KB_ARTICLE_VIEWS_FROM_PORTAL_SERIES("new-kb-article-views-from-portal", SeriesColor.ADG_LIME_GREEN, "sd.project.reports.kb.usage.article.views", YAxisType.COUNT, (List<String>)ImmutableList.of((Object)"sd.project.reports.drilldown.kb.article", (Object)"sd.project.reports.drilldown.kb.views", (Object)"sd.project.reports.drilldown.kb.solved.by.self.service", (Object)"sd.project.reports.drilldown.kb.created.by", (Object)"sd.project.reports.drilldown.kb.last.modified")),
    NEW_KB_REQUESTS_SOLVED_BY_AGENTS_SHARING_SERIES("new-kb-requests-solved-by-sharing", SeriesColor.ADG_BLUE, "sd.project.reports.kb.usage.article.views", YAxisType.COUNT, (List<String>)ImmutableList.of((Object)"sd.project.reports.drilldown.kb.article", (Object)"sd.project.reports.drilldown.kb.requests", (Object)"sd.project.reports.drilldown.kb.created.by", (Object)"sd.project.reports.drilldown.kb.last.modified")),
    NEW_KB_REQUESTS_SOLVED_BY_AGENTS_WITHOUT_SHARING_SERIES("new-kb-requests-solved-without-sharing", SeriesColor.ADG_RED, "sd.project.reports.kb.usage.article.views", YAxisType.COUNT, CommonI18n.COMMON_COLUMNS_I18N_KEYS);

    private final String id;
    private final SeriesColor color;
    private final String i18nLabel;
    private final YAxisType yAxisType;
    private final List<String> drilldownI18nKeys;

    private PredefinedReportSeries(String id, SeriesColor color, String i18nLabel, YAxisType yAxisType) {
        this(id, color, i18nLabel, yAxisType, Collections.EMPTY_LIST);
    }

    private PredefinedReportSeries(String id, SeriesColor color, String i18nLabel, YAxisType yAxisType, List<String> drilldownI18nKeys) {
        this.id = id;
        this.color = color;
        this.i18nLabel = i18nLabel;
        this.yAxisType = yAxisType;
        this.drilldownI18nKeys = drilldownI18nKeys;
    }

    public static Option<PredefinedReportSeries> fromId(String seriesId) {
        return Option.fromOptional(Lists.newArrayList((Object[])PredefinedReportSeries.values()).stream().filter(series -> series.getId().equals(seriesId)).findFirst());
    }

    public String getId() {
        return this.id;
    }

    public String getColor() {
        return this.color.getRgbValue();
    }

    public String getI18nLabel() {
        return this.i18nLabel;
    }

    public YAxisType getYAxisType() {
        return this.yAxisType;
    }

    public List<String> getDrilldownI18nKeys() {
        return this.drilldownI18nKeys;
    }
}

