/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.listener.kb;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.plugins.reports.internal.dao.kb.KBHelpfulAggregateDao;
import com.atlassian.servicedesk.plugins.reports.internal.domain.StatsEvent;
import com.atlassian.servicedesk.plugins.reports.internal.domain.kb.KBEventFactory;
import com.atlassian.servicedesk.plugins.reports.internal.listener.EventProcessor;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KBHelpfulEventProcessor
implements EventProcessor {
    private static final Set<String> SUPPORTED_KEYS = Sets.newHashSet((Object[])new String[]{"stats.event.kb.helpful.clicked"});
    private final KBEventFactory kbEventFactory;
    private final KBHelpfulAggregateDao kbHelpfulAggregateDao;

    @Autowired
    public KBHelpfulEventProcessor(KBEventFactory kbEventFactory, KBHelpfulAggregateDao kbHelpfulAggregateDao) {
        this.kbEventFactory = kbEventFactory;
        this.kbHelpfulAggregateDao = kbHelpfulAggregateDao;
    }

    @Override
    @Nonnull
    public Set<String> supportedEventKeys() {
        return SUPPORTED_KEYS;
    }

    @Override
    @Nonnull
    public Either<AnError, StatsEvent> processEvent(@Nonnull StatsEvent event) {
        return Steps.begin(this.kbEventFactory.toKbHelpfulEvent(event)).then(this.kbHelpfulAggregateDao::aggregateEvent).yield((kbEvent, processedKbEvent) -> event);
    }
}

