/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.listener;

import com.atlassian.analytics.client.api.browser.BrowserEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.plugins.kb.internal.api.events.KBArticleSharedEvent;
import com.atlassian.servicedesk.plugins.reports.internal.SDReportsFeatureFlags;
import com.atlassian.servicedesk.plugins.reports.internal.StatsEventManager;
import com.atlassian.servicedesk.plugins.reports.internal.domain.StatsEvent;
import com.atlassian.servicedesk.plugins.reports.internal.domain.StatsEventFactory;
import com.atlassian.servicedesk.plugins.reports.internal.listener.EventProcessor;
import com.atlassian.servicedesk.plugins.reports.internal.listener.EventProcessorRegistry;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StatsEventListeners {
    private static final Logger logger = LoggerFactory.getLogger(StatsEventListeners.class);
    private final StatsEventFactory statsEventFactory;
    private final EventProcessorRegistry eventProcessorRegistry;
    private final StatsEventManager statsEventManager;
    private final FeatureManager featureManager;

    @Autowired
    public StatsEventListeners(StatsEventFactory statsEventFactory, EventProcessorRegistry eventProcessorRegistry, StatsEventManager statsEventManager, FeatureManager featureManager) {
        this.statsEventFactory = statsEventFactory;
        this.eventProcessorRegistry = eventProcessorRegistry;
        this.statsEventManager = statsEventManager;
        this.featureManager = featureManager;
    }

    @EventListener
    public void onBrowserEvent(BrowserEvent browserEvent) {
        if (!this.featureManager.isEnabled(SDReportsFeatureFlags.STATS_EVENT_TRACKING)) {
            return;
        }
        if (this.eventProcessorRegistry.hasEventProcessorsForKey(browserEvent.getName())) {
            Steps.begin(this.statsEventFactory.browserToStatsEvent(browserEvent)).then(this.statsEventManager::recordEvent).yield((statsEvent, recordedStatsEvent) -> recordedStatsEvent).foreach(this::dispatchEventToProcessors);
        } else {
            logger.debug("No event processors were registered for event key " + browserEvent.getName());
        }
    }

    @EventListener
    public void onKBArticleSharedEvent(KBArticleSharedEvent kbArticleSharedEvent) {
        this.statsEventManager.recordEvent(this.statsEventFactory.kbArticleShareToStatsEvent(kbArticleSharedEvent));
    }

    private void dispatchEventToProcessors(StatsEvent event) {
        List<EventProcessor> eventProcessors = this.eventProcessorRegistry.getEventProcessors(event.getEventKey());
        for (EventProcessor eventProcessor : eventProcessors) {
            try {
                eventProcessor.processEvent(event).leftMap(err -> {
                    this.logProcessingError(event, eventProcessor);
                    return err;
                });
            }
            catch (Exception e) {
                this.logProcessingError(event, eventProcessor);
            }
        }
    }

    private void logProcessingError(StatsEvent event, EventProcessor eventProcessor) {
        String errorMessage = String.format("Error dispatching StatsEvent %s to event processor %s", event.getEventKey(), eventProcessor.getClass().getCanonicalName());
        logger.error(errorMessage);
    }
}

