/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.listener;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.servicedesk.plugins.reports.internal.listener.EventProcessor;
import com.atlassian.servicedesk.plugins.reports.internal.listener.EventProcessorRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventProcessorRegistryImpl
implements EventProcessorRegistry {
    private final List<EventProcessor> eventProcessors;
    @TenantAware(value=TenancyScope.TENANTLESS)
    private Map<String, List<EventProcessor>> eventProcessorsForKey = new HashMap<String, List<EventProcessor>>();

    @Autowired
    public EventProcessorRegistryImpl(List<EventProcessor> eventProcessors) {
        this.eventProcessors = Collections.unmodifiableList(eventProcessors);
    }

    @Override
    @Nonnull
    public List<EventProcessor> getEventProcessors(String eventKey) {
        ArrayList eventHandlersList = this.eventProcessorsForKey.get(eventKey);
        return eventHandlersList == null ? new ArrayList() : eventHandlersList;
    }

    @Override
    public boolean hasEventProcessorsForKey(String eventKey) {
        return !this.getEventProcessors(eventKey).isEmpty();
    }

    @PostConstruct
    protected void loadEventHandlers() {
        for (EventProcessor eventProcessor : this.eventProcessors) {
            Set<String> supportedKeys = eventProcessor.supportedEventKeys();
            for (String supportedKey : supportedKeys) {
                List<EventProcessor> currentEventProcessors = this.eventProcessorsForKey.get(supportedKey);
                if (currentEventProcessors == null) {
                    currentEventProcessors = new ArrayList<EventProcessor>();
                    this.eventProcessorsForKey.put(supportedKey, currentEventProcessors);
                }
                currentEventProcessors.add(eventProcessor);
            }
        }
    }
}

