/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.i18n;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommonI18n {
    public static final List<String> COMMON_COLUMNS_I18N_KEYS = ImmutableList.of((Object)"sd.common.words.key", (Object)"sd.request.details.summary", (Object)"sd.common.words.reporter", (Object)"sd.common.words.assignee", (Object)"sd.common.words.requestType");
    private final UserFactory userFactory;

    @Autowired
    public CommonI18n(UserFactory userFactory) {
        this.userFactory = userFactory;
    }

    public List<String> COMMON_COLUMNS() {
        I18nHelper i18nHelper = this.userFactory.getUncheckedUser().i18NHelper();
        return COMMON_COLUMNS_I18N_KEYS.stream().map(arg_0 -> ((I18nHelper)i18nHelper).getText(arg_0)).collect(Collectors.toList());
    }

    public String ISSUE_STATUS() {
        return this.userFactory.getUncheckedUser().i18NHelper().getText("sd.common.words.status");
    }

    public String ISSUE_RESOLUTION() {
        return this.userFactory.getUncheckedUser().i18NHelper().getText("sd.project.reports.drilldown.resolution");
    }

    public String REQUEST_CSAT() {
        return this.userFactory.getUncheckedUser().i18NHelper().getText("sd.project.reports.drilldown.csatRating");
    }

    public String SLA_ELAPSED() {
        return this.userFactory.getUncheckedUser().i18NHelper().getText("sd.project.reports.drilldown.elapsedTime");
    }

    public String SLA_MET() {
        return this.userFactory.getUncheckedUser().i18NHelper().getText("sd.project.reports.drilldown.timeRemaining");
    }

    public String SLA_BREACHED() {
        return this.userFactory.getUncheckedUser().i18NHelper().getText("sd.project.reports.drilldown.breachedTime");
    }
}

