/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.helper;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.report.ReportTimescale;
import com.atlassian.servicedesk.internal.api.report.ReportTimescaleManager;
import com.atlassian.servicedesk.plugins.reports.internal.helper.ReportTimescaleConversionHelper;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.TimeBreakdown;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.Timescale;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReportTimescaleConversionHelperImpl
implements ReportTimescaleConversionHelper {
    private final ErrorResultHelper errorResultHelper;
    private final ReportTimescaleManager reportTimescaleManager;

    @Autowired
    public ReportTimescaleConversionHelperImpl(ErrorResultHelper errorResultHelper, ReportTimescaleManager reportTimescaleManager) {
        this.errorResultHelper = errorResultHelper;
        this.reportTimescaleManager = reportTimescaleManager;
    }

    @Override
    public Option<Timescale> convertFromReportTimescale(ReportTimescale reportTimescale, DateTime endDate, DateTimeZone dateTimeZone) {
        return Steps.begin(TimeBreakdown.byPeriod(reportTimescale.getBreakdown().asJodaPeriod())).then(timeBreakdown -> Timescale.createTimescale(reportTimescale.getRange().asJodaPeriod(), timeBreakdown, endDate.getMillis(), dateTimeZone, this.errorResultHelper).right().toOption()).yield((timeBreakdown, timescale) -> timescale);
    }

    @Override
    public Either<AnError, Timescale> convertFromTimescaleId(Long timescaleId, DateTime endDate, DateTimeZone dateTimeZone) {
        return Steps.begin(this.getTimeScale(timescaleId)).then(reportTimescale -> this.convertFromReportTimescale((ReportTimescale)reportTimescale, endDate, dateTimeZone).toRight(() -> this.errorResultHelper.notFound404("sd.project.reports.export.timescale.not.found", new Object[0]).build())).yield((reportTimescale, result) -> result);
    }

    protected Either<AnError, ReportTimescale> getTimeScale(Long timescaleId) {
        if (timescaleId == null) {
            return Either.left((Object)this.errorResultHelper.badRequest400("sd.project.reports.timescale.missing", new Object[0]).build());
        }
        ReportTimescale timescale = this.reportTimescaleManager.getTimescale(timescaleId.longValue());
        if (timescale == null) {
            return Either.left((Object)this.errorResultHelper.badRequest400("sd.project.reports.timeperiod.invalid", new Object[]{timescaleId}).build());
        }
        return Either.right((Object)timescale);
    }
}

