/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.domain;

import com.atlassian.analytics.client.api.browser.BrowserEvent;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.kb.internal.api.events.KBArticleSharedEvent;
import com.atlassian.servicedesk.plugins.reports.internal.domain.StatsEvent;
import com.atlassian.servicedesk.plugins.reports.internal.domain.StatsEventErrors;
import com.atlassian.servicedesk.plugins.reports.internal.domain.StatsEventFactory;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StatsEventFactoryImpl
implements StatsEventFactory {
    private static final Logger logger = LoggerFactory.getLogger(StatsEventFactoryImpl.class);
    private final StatsEventErrors statsEventErrors;

    @Autowired
    public StatsEventFactoryImpl(StatsEventErrors statsEventErrors) {
        this.statsEventErrors = statsEventErrors;
    }

    @Override
    @Nonnull
    public Either<AnError, StatsEvent> browserToStatsEvent(@Nonnull BrowserEvent browserEvent) {
        return this.verifyBrowserEvent(browserEvent).map(u -> new StatsEvent(browserEvent.getClientTime(), browserEvent.getName(), this.filterOutNonStringPropertyValues(browserEvent.getProperties())));
    }

    @Override
    @Nonnull
    public StatsEvent kbArticleShareToStatsEvent(@Nonnull KBArticleSharedEvent kbArticleSharedEvent) {
        return new StatsEvent(kbArticleSharedEvent.getTime(), "stats.event.kb.article.shared", this.filterOutEmptyPropertyValues(kbArticleSharedEvent.getParams()));
    }

    private Map<String, String> filterOutEmptyPropertyValues(Map<String, Option<String>> browserEventProperties) {
        if (MapUtils.isEmpty(browserEventProperties)) {
            return Collections.emptyMap();
        }
        return browserEventProperties.entrySet().stream().filter(entry -> ((Option)entry.getValue()).isDefined()).collect(Collectors.toMap(Map.Entry::getKey, nonEmptyEntry -> ((String)((Option)nonEmptyEntry.getValue()).get()).toString()));
    }

    private Map<String, String> filterOutNonStringPropertyValues(Map<String, Object> browserEventProperties) {
        if (browserEventProperties == null || browserEventProperties.isEmpty()) {
            return Collections.emptyMap();
        }
        return browserEventProperties.entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()));
    }

    private Either<AnError, Unit> verifyBrowserEvent(@Nonnull BrowserEvent browserEvent) {
        boolean isValid = browserEvent.getClientTime() > 0L && StringUtils.isNotBlank((String)browserEvent.getName()) && browserEvent.getProperties() != null;
        return isValid ? Either.right((Object)Unit.VALUE) : Either.left((Object)this.buildEventConversionError(browserEvent));
    }

    private AnError buildEventConversionError(@Nonnull BrowserEvent browserEvent) {
        AnError error = this.statsEventErrors.eventConversionError(BrowserEvent.class, StatsEvent.class);
        logger.error(String.format("Error converting BrowserEvent %s: %s", browserEvent.getName(), error));
        return error;
    }
}

