/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.dao.kb;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.plugins.reports.internal.bootstrap.database.querydsl.kb.AbstractQKbEventAggregate;
import com.atlassian.servicedesk.plugins.reports.internal.dao.QueryDslDaoHelper;
import com.atlassian.servicedesk.plugins.reports.internal.domain.kb.AbstractKBEvent;
import com.atlassian.servicedesk.plugins.reports.internal.domain.kb.AbstractKBEventAggregate;
import com.google.common.collect.Lists;
import com.querydsl.core.Tuple;
import com.querydsl.core.dml.DMLClause;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import io.atlassian.fugue.Either;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKBEventAggregateDao<T extends AbstractKBEvent> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final QueryDslDaoHelper helper;
    private final ErrorResultHelper errorResultHelper;
    private final DatabaseAccessor databaseAccessor;

    protected AbstractKBEventAggregateDao(QueryDslDaoHelper helper, ErrorResultHelper errorResultHelper, DatabaseAccessor databaseAccessor) {
        this.helper = helper;
        this.errorResultHelper = errorResultHelper;
        this.databaseAccessor = databaseAccessor;
    }

    @Nonnull
    public Either<AnError, T> aggregateEvent(@Nonnull T kbArticleEvent) {
        try {
            this.databaseAccessor.runInTransaction(connection -> this.insertOrUpdateAggregateEntry((DatabaseConnection)connection, (AbstractKBEvent)kbArticleEvent));
            return Either.right(kbArticleEvent);
        }
        catch (RuntimeException e) {
            this.log.error("Exception during storing of kb article event", (Throwable)e);
            AnError anError = this.errorResultHelper.internalServiceError500("sd.project.reports.aggregate.store.error", new Object[]{"KB Article"}).build();
            return Either.left((Object)anError);
        }
    }

    public Either<AnError, List<AbstractKBEventAggregate>> getSeries(@Nonnull ServiceDesk serviceDesk, long startTime, long endTime) {
        try {
            List kbArticleAggregates = (List)this.databaseAccessor.runInTransaction(connection -> this.getRowsForPeriod((DatabaseConnection)connection, Lists.newArrayList((Object[])new Long[]{serviceDesk.getId()}), startTime, endTime - 1L));
            return Either.right((Object)kbArticleAggregates);
        }
        catch (RuntimeException e) {
            this.log.error("Exception during reading of kb article event", (Throwable)e);
            AnError anError = this.errorResultHelper.internalServiceError500("sd.project.reports.aggregate.read.error", new Object[]{"KB Article"}).build();
            return Either.left((Object)anError);
        }
    }

    @Nonnull
    protected abstract AbstractQKbEventAggregate<? extends AbstractQKbEventAggregate> getAggregateTable();

    @Nonnull
    protected abstract AbstractKBEventAggregate constructAggregate(long var1, long var3, long var5, long var7);

    private Either<AnError, AbstractKBEvent> insertOrUpdateAggregateEntry(DatabaseConnection databaseConnection, AbstractKBEvent kbArticleEvent) {
        long startHourTimeStamp = this.getStartHourLong(kbArticleEvent.getEventTime());
        List<Long> idsToInsert = kbArticleEvent.getServiceDeskIds();
        List<AbstractKBEventAggregate> rowsToUpdate = this.getRowsForPeriod(databaseConnection, idsToInsert, startHourTimeStamp);
        idsToInsert.removeAll(Lists.transform(rowsToUpdate, AbstractKBEventAggregate::getServiceDeskId));
        this.insertNewAggregateRows(databaseConnection, idsToInsert, startHourTimeStamp);
        this.updateExistingAggregateRows(databaseConnection, rowsToUpdate);
        return Either.right((Object)kbArticleEvent);
    }

    private long insertNewAggregateRows(DatabaseConnection databaseConnection, List<Long> serviceDeskIds, long startHourTimeStamp) {
        if (serviceDeskIds.isEmpty()) {
            return 0L;
        }
        SQLInsertClause batchInsertClause = databaseConnection.insert(this.getAggregateTable());
        for (long serviceDeskId : serviceDeskIds) {
            batchInsertClause.set(this.getAggregateTable().SERVICE_DESK_ID, (Object)serviceDeskId);
            batchInsertClause.set(this.getAggregateTable().COUNT, (Object)1L);
            batchInsertClause.set(this.getAggregateTable().START_TIME, (Object)startHourTimeStamp);
            batchInsertClause.addBatch();
        }
        return this.helper.executeMultipleRowUpdates((DMLClause)batchInsertClause, serviceDeskIds.size());
    }

    private long updateExistingAggregateRows(DatabaseConnection databaseConnection, List<AbstractKBEventAggregate> kbArticleAggregates) {
        if (kbArticleAggregates.isEmpty()) {
            return 0L;
        }
        AbstractQKbEventAggregate<AbstractQKbEventAggregate> aggregateTable = this.getAggregateTable();
        SQLUpdateClause batchUpdateClause = databaseConnection.update(aggregateTable);
        for (AbstractKBEventAggregate kbArticleAggregate : kbArticleAggregates) {
            batchUpdateClause.set(aggregateTable.COUNT, (Object)(kbArticleAggregate.getCount() + 1L));
            batchUpdateClause.where((Predicate)aggregateTable.ID.eq((Object)kbArticleAggregate.getId()));
            batchUpdateClause.addBatch();
        }
        return this.helper.executeMultipleRowUpdates((DMLClause)batchUpdateClause, kbArticleAggregates.size());
    }

    private List<AbstractKBEventAggregate> getRowsForPeriod(DatabaseConnection connection, List<Long> serviceDeskIds, long timeStamp) {
        return this.getRowsForPeriod(connection, serviceDeskIds, timeStamp, timeStamp);
    }

    private List<AbstractKBEventAggregate> getRowsForPeriod(DatabaseConnection databaseConnection, List<Long> serviceDeskIds, long startHourTimeStamp, long endHourTimeStamp) {
        AbstractQKbEventAggregate<AbstractQKbEventAggregate> aggregateTable = this.getAggregateTable();
        SQLQuery query = (SQLQuery)((SQLQuery)databaseConnection.select(new Expression[]{aggregateTable.ID, aggregateTable.SERVICE_DESK_ID, aggregateTable.START_TIME, aggregateTable.COUNT}).from(aggregateTable)).where((Predicate)aggregateTable.START_TIME.between((Number)startHourTimeStamp, (Number)endHourTimeStamp).and((Predicate)aggregateTable.SERVICE_DESK_ID.in(serviceDeskIds)));
        List tuples = query.fetch();
        ArrayList result = Lists.newArrayList();
        for (Tuple tuple : tuples) {
            Long id = (Long)tuple.get(aggregateTable.ID);
            Long serviceDeskId = (Long)tuple.get(aggregateTable.SERVICE_DESK_ID);
            Long startTime = (Long)tuple.get(aggregateTable.START_TIME);
            Long count = (Long)tuple.get(aggregateTable.COUNT);
            if (id == null || serviceDeskId == null || count == null || startTime == null) {
                this.log.warn("id (" + id + "), time (" + startTime + "), serviceDeskId (" + serviceDeskId + ") or count (" + count + ") is null for KB article aggregate row, query: " + query);
                continue;
            }
            result.add(this.constructAggregate(id, startTime, serviceDeskId, count));
        }
        return result;
    }

    private Long getStartHourLong(long timestamp) {
        return new DateTime(timestamp, DateTimeZone.UTC).hourOfDay().roundFloorCopy().getMillis();
    }
}

