/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.dao;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.plugins.reports.internal.bootstrap.database.querydsl.Tables;
import com.atlassian.servicedesk.plugins.reports.internal.dao.QueryDslDaoHelper;
import com.atlassian.servicedesk.plugins.reports.internal.dao.StatsEventDao;
import com.atlassian.servicedesk.plugins.reports.internal.domain.StatsEvent;
import com.querydsl.core.dml.DMLClause;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import io.atlassian.fugue.Either;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StatsEventDaoImpl
implements StatsEventDao {
    private static final Logger log = LoggerFactory.getLogger(StatsEventDaoImpl.class);
    private final QueryDslDaoHelper helper;
    private final DatabaseAccessor databaseAccessor;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public StatsEventDaoImpl(QueryDslDaoHelper helper, DatabaseAccessor databaseAccessor, ErrorResultHelper errorResultHelper) {
        this.helper = helper;
        this.databaseAccessor = databaseAccessor;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    @Nonnull
    public Either<AnError, StatsEvent> recordEvent(StatsEvent statsEvent) {
        try {
            return (Either)this.databaseAccessor.runInTransaction(connection -> {
                long insertedStatsEventId = this.insertStatsEvent((DatabaseConnection)connection, statsEvent);
                this.insertStatsEventParams((DatabaseConnection)connection, insertedStatsEventId, statsEvent);
                return Either.right((Object)statsEvent);
            });
        }
        catch (RuntimeException e) {
            String eventKey = statsEvent.getEventKey();
            log.error("Exception during storing of stats event with key:" + eventKey, (Throwable)e);
            AnError anError = this.errorResultHelper.internalServiceError500("sd.project.reports.events.store.error", new Object[]{eventKey}).build();
            return Either.left((Object)anError);
        }
    }

    @Override
    @Nonnull
    public Either<AnError, Long> deleteEventsBefore(long timestamp) {
        try {
            return (Either)this.databaseAccessor.runInTransaction(connection -> {
                long numberOfRowsDeleted = this.deleteRows((DatabaseConnection)connection, timestamp);
                return Either.right((Object)numberOfRowsDeleted);
            });
        }
        catch (RuntimeException e) {
            log.error("Exception during deletion of stats event with timestamp before " + timestamp, (Throwable)e);
            AnError anError = this.errorResultHelper.internalServiceError500("sd.project.reports.events.delete.error", new Object[]{timestamp}).build();
            return Either.left((Object)anError);
        }
    }

    private long deleteRows(DatabaseConnection databaseConnection, Long timeStamp) {
        SQLQuery selectQuery = (SQLQuery)((SQLQuery)databaseConnection.select(Tables.STATS_EVENT.ID).from((Expression)Tables.STATS_EVENT)).where((Predicate)Tables.STATS_EVENT.EVENT_TIME.lt((Number)timeStamp));
        List ids = selectQuery.fetch();
        databaseConnection.delete((RelationalPath)Tables.STATS_EVENT_PARAM).where((Predicate)Tables.STATS_EVENT_PARAM.STATS_EVENT_ID.in((Collection)ids)).execute();
        long numberOfRowsDeleted = databaseConnection.delete((RelationalPath)Tables.STATS_EVENT).where((Predicate)Tables.STATS_EVENT.ID.in((Collection)ids)).execute();
        return numberOfRowsDeleted;
    }

    private long insertStatsEventParams(DatabaseConnection databaseConnection, Long statsEventId, StatsEvent statsEvent) {
        Set<Map.Entry<String, String>> parameters = statsEvent.getEventParams().entrySet();
        if (parameters.isEmpty()) {
            return 0L;
        }
        SQLInsertClause batchInsertStatement = databaseConnection.insert((RelationalPath)Tables.STATS_EVENT_PARAM);
        for (Map.Entry<String, String> entry : parameters) {
            batchInsertStatement.set(Tables.STATS_EVENT_PARAM.STATS_EVENT_ID, (Object)statsEventId);
            batchInsertStatement.set((Path)Tables.STATS_EVENT_PARAM.PARAM_NAME, (Object)entry.getKey());
            batchInsertStatement.set((Path)Tables.STATS_EVENT_PARAM.PARAM_VALUE, (Object)this.getTruncatedString(entry.getValue(), 450));
            batchInsertStatement.addBatch();
        }
        return this.helper.executeMultipleRowUpdates((DMLClause)batchInsertStatement, parameters.size());
    }

    private long insertStatsEvent(DatabaseConnection databaseConnection, StatsEvent statsEvent) {
        SQLInsertClause insertClause = databaseConnection.insert((RelationalPath)Tables.STATS_EVENT).set((Path)Tables.STATS_EVENT.EVENT_KEY, (Object)statsEvent.getEventKey()).set(Tables.STATS_EVENT.EVENT_TIME, (Object)statsEvent.getEventTime());
        return this.helper.executeSingleRowInsertReturningId(databaseConnection, insertClause);
    }

    private String getTruncatedString(String value, int maxLength) {
        return value.substring(0, Math.min(value.length(), maxLength));
    }
}

