/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.collector.translator;

import com.atlassian.jira.util.LuceneUtils;
import com.atlassian.servicedesk.plugins.reports.internal.collector.input.DateTimeValue;
import com.atlassian.servicedesk.plugins.reports.internal.collector.translator.LuceneTranslator;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DateLuceneTranslator
implements LuceneTranslator<DateTimeValue<Long>> {
    private final String field;
    private final DateTimeZone zone;
    private Option<DateTimeValue<Long>> valueOption;

    public DateLuceneTranslator(String field, DateTimeZone zone) {
        this.field = field;
        this.zone = zone;
        this.valueOption = Option.none();
    }

    @Override
    public void addField(Long issueId, String issueKey, String fieldName, String data) {
        if (StringUtils.isNotBlank((String)data) && this.valueOption.isEmpty()) {
            DateTime dateTime = new DateTime((Object)LuceneUtils.stringToDate((String)data), this.zone);
            DateTimeValue<Long> dateTimeValue = new DateTimeValue<Long>(dateTime.getMillis(), 1L);
            this.valueOption = Option.some(dateTimeValue);
        }
    }

    @Override
    public Option<DateTimeValue<Long>> build(Long issueId, String issueKey) {
        Option<DateTimeValue<Long>> result = this.valueOption;
        this.valueOption = Option.none();
        return result;
    }

    @Override
    public Set<String> relevantFields() {
        return Collections.singleton(this.field);
    }
}

