/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.collector.translator;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.plugins.workinghours.api.calculator.WorkingHoursCalculator;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.sla.metric.BasicCycleData;
import com.atlassian.servicedesk.internal.api.sla.metric.CalculatorLookup;
import com.atlassian.servicedesk.internal.api.sla.metric.SLALuceneDocumentDataManager;
import com.atlassian.servicedesk.plugins.reports.internal.collector.input.DateTimeValue;
import com.atlassian.servicedesk.plugins.reports.internal.collector.translator.LuceneTranslator;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class AbstractTimeMetricTranslator
implements LuceneTranslator<DateTimeValue<Long>> {
    private final CalculatorLookup calculatorLookup;
    private final Option<CustomField> field;
    private final DateTimeZone zone;
    private final SLALuceneDocumentDataManager slaLuceneDocumentDataManager;
    private DateTime now;
    private Option<String> rawTimeline;

    public SLALuceneDocumentDataManager getSlaLuceneDocumentDataManager() {
        return this.slaLuceneDocumentDataManager;
    }

    public AbstractTimeMetricTranslator(CalculatorLookup calculatorLookup, Option<CustomField> field, DateTimeZone zone, SLALuceneDocumentDataManager slaLuceneDocumentDataManager) {
        this.calculatorLookup = calculatorLookup;
        this.field = field;
        this.zone = zone;
        this.slaLuceneDocumentDataManager = slaLuceneDocumentDataManager;
        this.now = new DateTime();
        this.rawTimeline = Option.none();
    }

    @Override
    public void addField(Long issueId, String issueKey, String fieldName, String data) {
        boolean matchesField;
        if (this.field.isDefined() && StringUtils.isNotBlank((CharSequence)fieldName) && (matchesField = fieldName.equals(this.slaLuceneDocumentDataManager.getTimelineFieldIdForIndexing((CustomField)this.field.get())))) {
            this.rawTimeline = Option.some((Object)data);
        }
    }

    @Override
    public Set<String> relevantFields() {
        if (this.field.isDefined()) {
            return Sets.newHashSet((Object[])new String[]{this.slaLuceneDocumentDataManager.getTimelineFieldIdForIndexing((CustomField)this.field.get())});
        }
        return Sets.newHashSet();
    }

    @Override
    public Option<DateTimeValue<Long>> build(Long issueId, String issueKey) {
        return Steps.begin(this.rawTimeline).then(raw -> {
            WorkingHoursCalculator defaultCalculator = this.calculatorLookup.getCalculatorForIssue(issueId);
            return this.slaLuceneDocumentDataManager.getDataFromMostRecentCycle(defaultCalculator, raw, issueId, this.now);
        }).yield((raw, cycle) -> this.buildValue((BasicCycleData)cycle));
    }

    public abstract DateTimeValue<Long> buildValue(BasicCycleData var1);

    public DateTimeZone getZone() {
        return this.zone;
    }
}

