/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.collector.callback;

import com.atlassian.pocketknife.api.search.issue.callback.DataCallback;
import com.atlassian.servicedesk.plugins.reports.internal.collector.DataCollector;
import com.atlassian.servicedesk.plugins.reports.internal.collector.result.DataCollectorResult;
import com.atlassian.servicedesk.plugins.reports.internal.collector.translator.LuceneTranslator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class MultiFieldCallback<A, B extends DataCollectorResult>
implements DataCallback {
    private final LuceneTranslator<A> documentBuilder;
    private final DataCollector<A, B> multiFieldCollector;

    public MultiFieldCallback(LuceneTranslator<A> documentBuilder, DataCollector<A, B> multiFieldCollector) {
        this.documentBuilder = documentBuilder;
        this.multiFieldCollector = multiFieldCollector;
    }

    public Set<String> getFields() {
        return this.documentBuilder.relevantFields();
    }

    public void fieldData(Long issueId, String issueKey, String fieldName, String data) {
        if (StringUtils.isNotBlank((String)data)) {
            this.documentBuilder.addField(issueId, issueKey, fieldName, data);
        }
    }

    public void documentComplete(Long issueId, String issueKey) {
        this.documentBuilder.build(issueId, issueKey).foreach(this.multiFieldCollector::collect);
    }

    public DataCollector<A, B> getMultiFieldCollector() {
        return this.multiFieldCollector;
    }
}

