/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.collector.callback;

import com.atlassian.pocketknife.annotations.lucene.LuceneUsage;
import com.atlassian.pocketknife.api.search.issue.callback.DataCallback;
import com.atlassian.servicedesk.plugins.reports.internal.collector.callback.CollectedIssue;
import com.atlassian.servicedesk.plugins.reports.internal.collector.input.DateTimeValue;
import com.atlassian.servicedesk.plugins.reports.internal.collector.translator.LuceneTranslator;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.Timescale;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.lang.StringUtils;

@VisibleForTesting
@LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueCollection)
public class IssueCallBack<A extends Number, B extends DateTimeValue<A>>
implements DataCallback {
    private final LuceneTranslator<B> documentBuilder;
    private final ImmutableSortedSet.Builder<CollectedIssue> issues;
    private final Timescale timescale;

    public IssueCallBack(LuceneTranslator<B> documentBuilder, Timescale timescale) {
        this.timescale = timescale;
        this.documentBuilder = documentBuilder;
        this.issues = ImmutableSortedSet.naturalOrder();
    }

    public Set<String> getFields() {
        return this.documentBuilder.relevantFields();
    }

    public void fieldData(Long issueId, String issueKey, String fieldName, String data) {
        if (StringUtils.isNotBlank((String)data)) {
            this.documentBuilder.addField(issueId, issueKey, fieldName, data);
        }
    }

    public void documentComplete(Long issueId, String issueKey) {
        this.documentBuilder.build(issueId, issueKey).forEach(input -> this.timescale.getBucketIndex(input.getDateTimeMillis()).forEach(index -> this.issues.add((Object)new CollectedIssue(issueId, ((Number)input.getValue()).longValue()))));
    }

    public SortedSet<CollectedIssue> getIssues() {
        return this.issues.build();
    }
}

