/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.collector;

import com.atlassian.pocketknife.annotations.lucene.LuceneUsage;
import com.atlassian.servicedesk.plugins.reports.internal.collector.AbstractAverageCollector;
import com.atlassian.servicedesk.plugins.reports.internal.collector.CollectorUtils;
import com.atlassian.servicedesk.plugins.reports.internal.collector.result.DataCollectorResult;
import com.atlassian.servicedesk.plugins.reports.internal.collector.result.IntervalValue;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.Timescale;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.joda.time.Interval;

@LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueAggregation)
public class DurationCollector
extends AbstractAverageCollector<Long, Long> {
    public DurationCollector(Timescale timescale) {
        super(timescale);
    }

    @Override
    public DataCollectorResult<Long> data() {
        List<Interval> timeIntervals = this.timescale.getTimeIntervals();
        Long averageOfAverages = CollectorUtils.safeDivide((Long)this.totalSum, (Long)this.totalIssues, 0L);
        List intervalValues = IntStream.range(0, this.bucketSums.length).mapToObj(index -> {
            Long intervalAverage = CollectorUtils.safeDivide((Long)this.bucketSums[index], (Long)this.countBucket[index], 1L);
            return new IntervalValue<Long>((Interval)timeIntervals.get(index), intervalAverage);
        }).collect(Collectors.toList());
        return new DataCollectorResult<Long>(intervalValues, averageOfAverages);
    }
}

