/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.collector;

import com.atlassian.pocketknife.annotations.lucene.LuceneUsage;
import com.atlassian.servicedesk.plugins.reports.internal.collector.AbstractAverageCollector;
import com.atlassian.servicedesk.plugins.reports.internal.collector.CollectorUtils;
import com.atlassian.servicedesk.plugins.reports.internal.collector.result.DataCollectorResult;
import com.atlassian.servicedesk.plugins.reports.internal.collector.result.IntervalValue;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.Timescale;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.joda.time.Interval;

@LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueAggregation)
public class AverageCollector
extends AbstractAverageCollector<Integer, Double> {
    public AverageCollector(Timescale timescale) {
        super(timescale);
    }

    @Override
    public DataCollectorResult<Double> data() {
        List<Interval> timeIntervals = this.timescale.getTimeIntervals();
        Double averageOfAverages = CollectorUtils.safeDivide((Long)this.totalSum, (Long)this.totalIssues, 0.0);
        List intervalValues = IntStream.range(0, this.bucketSums.length).mapToObj(index -> {
            Double intervalAverage = CollectorUtils.safeDivide((Long)this.bucketSums[index], (Long)this.countBucket[index], 0.0);
            return new IntervalValue<Double>((Interval)timeIntervals.get(index), intervalAverage);
        }).collect(Collectors.toList());
        return new DataCollectorResult<Double>(intervalValues, averageOfAverages);
    }
}

