/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal.bootstrap.database;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.servicedesk.plugins.reports.internal.dao.StatsEventDao;
import io.atlassian.fugue.Either;
import java.util.Date;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StatsEventDatabaseShredder
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(StatsEventDatabaseShredder.class);
    static final JobRunnerKey SHREDDER_JOB_RUNNER_KEY = JobRunnerKey.of((String)"com.atlassian.servicedesk.plugins.reports.internal.bootstrap.database.StatsEventDatabaseShredder");
    static final JobId SHREDDER_JOB_ID = JobId.of((String)"com.atlassian.servicedesk.plugins.reports.internal.bootstrap.database.StatsEventDatabaseShredder");
    private static final int BUFFER_DAYS = 2;
    private static final int CLEANUP_FREQUENCY_IN_MILLIS = 86400000;
    private static final int CLEANUP_DELAY_IN_MILLIS = 86400000;
    private final SchedulerService schedulerService;
    private final StatsEventDao statsEventDao;
    private final I18nHelper.BeanFactory i18nFactory;

    @Autowired
    public StatsEventDatabaseShredder(SchedulerService schedulerService, StatsEventDao statsEventDao, I18nHelper.BeanFactory i18nFactory) {
        this.schedulerService = schedulerService;
        this.statsEventDao = statsEventDao;
        this.i18nFactory = i18nFactory;
    }

    public void registerJobRunner() {
        this.schedulerService.registerJobRunner(SHREDDER_JOB_RUNNER_KEY, (JobRunner)this);
    }

    public void unregisterJobRunner() {
        this.schedulerService.unregisterJobRunner(SHREDDER_JOB_RUNNER_KEY);
    }

    public void scheduleJob() {
        try {
            log.info("Scheduling stats event cleanup task");
            this.schedulerService.scheduleJob(SHREDDER_JOB_ID, this.jobConfigOncePerCluster(SHREDDER_JOB_RUNNER_KEY));
        }
        catch (SchedulerServiceException e) {
            log.error("Shredder failed to schedule cleanup job", (Throwable)e);
        }
    }

    public void unscheduleJob() {
        this.schedulerService.unscheduleJob(SHREDDER_JOB_ID);
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        if (jobRunnerRequest.isCancellationRequested()) {
            log.info("Stats event collector cleanup task is cancelled and will not execute");
            return JobRunnerResponse.aborted((String)"Job is cancelled");
        }
        return this.executeCleanup();
    }

    public JobRunnerResponse executeCleanup() {
        Long earliestTimeToCleanup = this.getEarliestTimeToCleanup();
        log.info("Stats event collector cleanup task started, all stats events before {0} will be removed", (Object)earliestTimeToCleanup);
        Either<AnError, Long> numberOfRowsDeletedEither = this.statsEventDao.deleteEventsBefore(earliestTimeToCleanup);
        I18nHelper i18nHelper = this.i18nFactory.getInstance((ApplicationUser)null);
        return (JobRunnerResponse)numberOfRowsDeletedEither.fold(e -> {
            String errorMessage = i18nHelper.getText("sd.project.reports.stats.event.cleanup.failed", this.getReadableTimeFromLong(earliestTimeToCleanup)) + "\n" + e.getMessage().getMessage();
            log.error(errorMessage);
            return JobRunnerResponse.failed((String)errorMessage);
        }, numberOfRowsDeleted -> {
            String successMessage = i18nHelper.getText("sd.project.reports.stats.event.cleanup.success", this.getReadableTimeFromLong(earliestTimeToCleanup), numberOfRowsDeleted.toString());
            log.info(successMessage);
            return JobRunnerResponse.success((String)successMessage);
        });
    }

    private Long getEarliestTimeToCleanup() {
        return DateTime.now((DateTimeZone)DateTimeZone.UTC).minusYears(1).minusDays(2).getMillis();
    }

    private JobConfig jobConfigOncePerCluster(JobRunnerKey jobRunnerKey) {
        long aDayAfterNowInMillis = DateTime.now().getMillis() + 86400000L;
        return JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)86400000L, (Date)new Date(aDayAfterNowInMillis)));
    }

    private String getReadableTimeFromLong(Long time) {
        return new DateTime((Object)time).toString("d MMM yyyy HH:mm:ss z");
    }
}

