/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal;

import com.atlassian.fugue.Either;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.plugins.reports.internal.ReportManager;
import com.atlassian.servicedesk.plugins.reports.internal.ReportService;
import com.atlassian.servicedesk.plugins.reports.internal.rest.response.ReportDataResponse;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.Timescale;
import io.atlassian.fugue.Eithers;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReportServiceImpl
implements ReportService {
    private final ReportManager reportManager;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public ReportServiceImpl(ReportManager reportManager, ServiceDeskPermissionService serviceDeskPermissionService, ErrorResultHelper errorResultHelper) {
        this.reportManager = reportManager;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<AnError, ReportDataResponse> getReport(ApplicationUser user, String reportId, ServiceDesk serviceDesk, Timescale timescale) {
        return Steps.begin(this.checkIsPermitted(user, serviceDesk)).then(permittedUser -> this.reportManager.getReport(reportId, serviceDesk, timescale)).yield((permittedUser, report) -> report);
    }

    private io.atlassian.fugue.Either<AnError, ApplicationUser> checkIsPermitted(ApplicationUser user, ServiceDesk serviceDesk) {
        return StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAgent(user, serviceDesk)).flatMap(isPermitted -> Eithers.cond((boolean)isPermitted, (Object)this.errorResultHelper.forbidden403("sd.project.reports.not.permitted.view.report", new Object[0]).build(), (Object)user));
    }
}

