/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal;

import com.atlassian.fugue.Either;
import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.util.fp.FpKit;
import com.atlassian.servicedesk.plugins.reports.internal.ReportManager;
import com.atlassian.servicedesk.plugins.reports.internal.SDReportsFeatureFlags;
import com.atlassian.servicedesk.plugins.reports.internal.model.PredefinedReport;
import com.atlassian.servicedesk.plugins.reports.internal.rest.response.ReportDataResponse;
import com.atlassian.servicedesk.plugins.reports.internal.rest.response.ReportSeriesResponse;
import com.atlassian.servicedesk.plugins.reports.internal.series.ReportSeries;
import com.atlassian.servicedesk.plugins.reports.internal.series.ReportSeriesManager;
import com.atlassian.servicedesk.plugins.reports.internal.timeutil.Timescale;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReportManagerImpl
implements ReportManager {
    private final FeatureManager featureManager;
    private final ErrorResultHelper errorResultHelper;
    private final ReportSeriesManager reportSeriesManager;

    @Autowired
    public ReportManagerImpl(FeatureManager featureManager, ErrorResultHelper errorResultHelper, ReportSeriesManager reportSeriesManager) {
        this.featureManager = featureManager;
        this.errorResultHelper = errorResultHelper;
        this.reportSeriesManager = reportSeriesManager;
    }

    @Override
    @Nonnull
    public io.atlassian.fugue.Either<AnError, ReportDataResponse> getReport(String reportId, ServiceDesk serviceDesk, Timescale timescale) {
        if (PredefinedReport.KB_USAGE_REPORT.getId().equals(reportId)) {
            return this.getKbUsageReport(serviceDesk, timescale);
        }
        if (PredefinedReport.KB_EFFECTIVENESS_REPORT.getId().equals(reportId)) {
            return this.getKbEffectivenessReport(serviceDesk, timescale);
        }
        if (PredefinedReport.KB_SELF_SERVICE_REPORT.getId().equals(reportId)) {
            return this.getKBSelfServiceReport(serviceDesk, timescale);
        }
        if (PredefinedReport.KB_ARTICLE_HELPFULNESS_REPORT.getId().equals(reportId)) {
            return this.getKBArticleHelpfulnessReport(serviceDesk, timescale);
        }
        return StepsConverters.newerEither((Either)this.errorResultHelper.notFound404("sd.project.reports.report.id.not.found", new Object[]{reportId}).toEither());
    }

    private io.atlassian.fugue.Either<AnError, ReportDataResponse> getKbEffectivenessReport(ServiceDesk serviceDesk, Timescale timescale) {
        return Steps.begin(this.getReport(PredefinedReport.KB_EFFECTIVENESS_REPORT, serviceDesk, timescale)).yield(reportData -> reportData);
    }

    private io.atlassian.fugue.Either<AnError, ReportDataResponse> getKbUsageReport(ServiceDesk serviceDesk, Timescale timescale) {
        return Steps.begin(this.getReport(PredefinedReport.KB_USAGE_REPORT, serviceDesk, timescale)).yield(reportData -> reportData);
    }

    private io.atlassian.fugue.Either<AnError, ReportDataResponse> getKBSelfServiceReport(ServiceDesk serviceDesk, Timescale timescale) {
        return Steps.begin(this.checkFeatureFlagEnabled(SDReportsFeatureFlags.KB_SELF_SERVICE_REPORT)).then(enabledFlag -> this.getReport(PredefinedReport.KB_SELF_SERVICE_REPORT, serviceDesk, timescale)).yield((enabledFlag, reportData) -> reportData);
    }

    private io.atlassian.fugue.Either<AnError, ReportDataResponse> getKBArticleHelpfulnessReport(ServiceDesk serviceDesk, Timescale timescale) {
        return Steps.begin(this.checkFeatureFlagEnabled(SDReportsFeatureFlags.KB_ARTICLE_HELPFULNESS_REPORT)).then(enabledFlag -> this.getReport(PredefinedReport.KB_ARTICLE_HELPFULNESS_REPORT, serviceDesk, timescale)).yield((enabledFlag, reportData) -> reportData);
    }

    private io.atlassian.fugue.Either<AnError, FeatureFlag> checkFeatureFlagEnabled(FeatureFlag featureFlag) {
        return Eithers.cond((boolean)this.featureManager.isEnabled(featureFlag), (Object)this.errorResultHelper.badRequest400("sd.project.reports.feature.not.enabled", new Object[]{featureFlag.featureKey()}).build(), (Object)featureFlag);
    }

    private io.atlassian.fugue.Either<AnError, ReportDataResponse> getReport(PredefinedReport predefinedReport, ServiceDesk serviceDesk, Timescale timescale) {
        List seriesDataEithers = FpKit.map(predefinedReport.getSeries(), preDefinedSeries -> this.reportSeriesManager.getReportSeriesData(preDefinedSeries.getId(), serviceDesk, timescale));
        Option seriesErrorOpt = Iterables.findFirst((Iterable)seriesDataEithers, io.atlassian.fugue.Either::isLeft).flatMap(seriesWithError -> seriesWithError.left().toOption());
        return (io.atlassian.fugue.Either)seriesErrorOpt.fold(() -> io.atlassian.fugue.Either.right((Object)this.toReportData(predefinedReport, seriesDataEithers)), io.atlassian.fugue.Either::left);
    }

    private ReportDataResponse toReportData(PredefinedReport predefinedReport, List<io.atlassian.fugue.Either<AnError, ReportSeries>> validSeriesData) {
        List seriesData = FpKit.map(validSeriesData, series -> ReportSeriesResponse.builder().withReportSeries((ReportSeries)series.right().get()).build());
        return new ReportDataResponse(predefinedReport.getId(), seriesData, predefinedReport.name(), false, 0L);
    }
}

