/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.reports.internal;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.model.WebFragmentBuilder;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.internal.api.project.ProjectUrls;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.internal.api.report.Report;
import com.atlassian.servicedesk.internal.api.report.ReportService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomReportsItemProvider
implements WebItemProvider {
    private JiraAuthenticationContext authenticationContext;
    private ReportService reportService;
    private ProjectService projectService;
    private ServiceDeskService serviceDeskService;
    private ProjectUrlsProvider projectUrlProvider;

    @Autowired
    public CustomReportsItemProvider(JiraAuthenticationContext authenticationContext, ReportService reportService, ProjectService projectService, ServiceDeskService serviceDeskService, ProjectUrlsProvider projectUrlProvider) {
        this.authenticationContext = authenticationContext;
        this.reportService = reportService;
        this.projectService = projectService;
        this.serviceDeskService = serviceDeskService;
        this.projectUrlProvider = projectUrlProvider;
    }

    public Iterable<WebItem> getItems(Map<String, Object> context) {
        ArrayList items = Lists.newArrayList();
        if (!context.containsKey("projectKey")) {
            return items;
        }
        String projectKey = (String)context.get("projectKey");
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(user, projectKey);
        if (!projectResult.isValid()) {
            return items;
        }
        io.atlassian.fugue.Either serviceDeskResult = StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user, projectResult.getProject()));
        if (!serviceDeskResult.isRight()) {
            return items;
        }
        io.atlassian.fugue.Either reportsResult = this.reportService.getReports(user, (ServiceDesk)serviceDeskResult.right().get());
        if (!reportsResult.isRight()) {
            return items;
        }
        ProjectUrls projectUrls = this.projectUrlProvider.getUrls(projectKey, ProjectUrlsProvider.UrlMode.RELATIVE);
        Collection reports = (Collection)reportsResult.right().get();
        for (Report report : reports) {
            WebItem item = new WebFragmentBuilder("com.atlassian.servicedesk:reports-nav-" + report.getId(), 0).label(report.getName()).addParam("entityId", "" + report.getId()).addParam("pageId", "custom").webItem("").url(projectUrls.customReport(report.getId().toString()).toASCIIString()).build();
            items.add(item);
        }
        return items;
    }
}

