/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.web.sidebar;

import com.atlassian.jira.projects.api.sidebar.SidebarRenderer;
import com.atlassian.jira.projects.api.sidebar.footer.SettingsButton;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.internal.api.project.ProjectUrls;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.project.internal.context.ServiceDeskProjectContext;
import com.atlassian.servicedesk.project.internal.web.sidebar.ServiceDeskSidebarContentRenderer;
import com.atlassian.servicedesk.project.internal.web.sidebar.ServiceDeskSidebarHeaderRenderer;
import com.atlassian.servicedesk.project.internal.web.sidebar.ServiceDeskSidebarRenderer;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskSidebarRendererImpl
implements ServiceDeskSidebarRenderer {
    @Autowired
    private ProjectUrlsProvider projectUrlsProvider;
    @Autowired
    private ServiceDeskSidebarContentRenderer contentRenderer;
    @Autowired
    private ServiceDeskSidebarHeaderRenderer headerRenderer;
    @Autowired
    private SidebarRenderer sidebarRenderer;
    @Autowired
    private JiraAuthenticationContext authenticationContext;

    private Option<SettingsButton> getSettingsButton(ServiceDeskProjectContext context) {
        ProjectUrls projectUrls = this.projectUrlsProvider.getUrls(context.getProject().getKey(), ProjectUrlsProvider.UrlMode.RELATIVE);
        String adminUrl = projectUrls.projectSettings().toASCIIString();
        String adminText = this.authenticationContext.getI18nHelper().getText("project.sidebar.settings.button.label");
        return context.isAgentAdmin() ? StepsConverters.newerOption((com.atlassian.fugue.Option)SettingsButton.buttonOf((String)adminUrl, (String)adminText)) : Option.none();
    }

    @Override
    public String render(ServiceDeskProjectContext context, String selectedItemId) {
        return this.sidebarRenderer.render(this.contentRenderer.render(context, selectedItemId), this.headerRenderer.render(context.getProject()), StepsConverters.olderOption(this.getSettingsButton(context)));
    }
}

