/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.web.sidebar;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.api.sidebar.header.HeaderRenderer;
import com.atlassian.jira.projects.api.sidebar.header.HeaderRendererParameters;
import com.atlassian.jira.projects.api.sidebar.header.HeaderRendererParametersBuilder;
import com.atlassian.servicedesk.internal.api.project.ProjectUrls;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskSidebarHeaderRenderer {
    @Autowired
    private HeaderRenderer headerRenderer;
    @Autowired
    private AvatarService avatarService;
    @Autowired
    private ProjectUrlsProvider projectUrlProvider;

    private String getAvatarUrl(Project project) {
        return this.avatarService.getProjectAvatarURL(project, Avatar.Size.LARGE).toString();
    }

    public String render(Project project) {
        ProjectUrls projectUrls = this.projectUrlProvider.getUrls(project.getKey(), ProjectUrlsProvider.UrlMode.WITHOUT_CONTEXT);
        HeaderRendererParameters headerParameters = new HeaderRendererParametersBuilder().heading(project.getName()).avatarUrl(this.getAvatarUrl(project)).linkUrl(projectUrls.queues().toASCIIString()).selected(false).build();
        return this.headerRenderer.render(headerParameters);
    }
}

