/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.web.sidebar;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeManager;
import com.atlassian.jira.projects.api.sidebar.content.ContentRenderer;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.project.type.ServiceDeskProjectType;
import com.atlassian.servicedesk.project.internal.context.ServiceDeskProjectContext;
import com.atlassian.servicedesk.project.internal.context.ServiceDeskProjectContextProvider;
import com.atlassian.servicedesk.project.internal.web.pagedata.ProjectDataAssembler;
import com.atlassian.servicedesk.project.internal.web.sidebar.ServiceDeskSidebarContentRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.RequiredResources;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Either;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskSidebarContentRendererImpl
implements ServiceDeskSidebarContentRenderer {
    public static final String WEB_PANEL_LOCATION = "servicedesk.project.sidebar";
    private final ContentRenderer contentRenderer;
    private final ServiceDeskProjectContextProvider serviceDeskProjectContextProvider;
    private final PageBuilderService pageBuilderService;
    private final ProjectTypeManager projectTypeManager;
    private final ProjectDataAssembler projectDataAssembler;

    @Autowired
    public ServiceDeskSidebarContentRendererImpl(ContentRenderer contentRenderer, ServiceDeskProjectContextProvider serviceDeskProjectContextProvider, PageBuilderService pageBuilderService, ProjectTypeManager projectTypeManager, ProjectDataAssembler projectDataAssembler) {
        this.contentRenderer = contentRenderer;
        this.serviceDeskProjectContextProvider = serviceDeskProjectContextProvider;
        this.pageBuilderService = pageBuilderService;
        this.projectTypeManager = projectTypeManager;
        this.projectDataAssembler = projectDataAssembler;
    }

    public String render(Project project, String selectedItemId) {
        Either<AnError, ServiceDeskProjectContext> contextResult = this.serviceDeskProjectContextProvider.getContext(project.getKey());
        if (contextResult.isLeft()) {
            throw new RuntimeException("This is a Service Desk project, but we were unable to load the Service Desk project context. It may be possible to fix this error by converting this project to a different project type, and then converting it back to Service Desk.");
        }
        return this.render((ServiceDeskProjectContext)contextResult.right().get(), selectedItemId);
    }

    @Override
    public String render(ServiceDeskProjectContext context, String selectedItemId) {
        if (!this.projectTypeManager.isProjectTypeInstalledButInaccessible(ServiceDeskProjectType.KEY)) {
            this.assembleRequiredResources();
            this.assembleRequiredData(context);
        }
        return this.renderContent(context, selectedItemId);
    }

    private void assembleRequiredResources() {
        RequiredResources resourcesAssembler = this.pageBuilderService.assembler().resources();
        resourcesAssembler.requireContext("sd.project.sidebar.content");
    }

    private void assembleRequiredData(ServiceDeskProjectContext context) {
        this.projectDataAssembler.assembleData(context);
    }

    private String renderContent(ServiceDeskProjectContext context, String selectedItemId) {
        ImmutableMap.Builder projectContext = ImmutableMap.builder();
        projectContext.put((Object)"projectUrls", (Object)context.getProjectUrls());
        projectContext.put((Object)"portalId", (Object)context.getPortal().getId());
        projectContext.put((Object)"project", (Object)context.getProject());
        context.getUser().foreach(applicationUser -> projectContext.put((Object)"user", applicationUser));
        if (selectedItemId != null) {
            projectContext.put((Object)"selectedItemId", (Object)selectedItemId);
        }
        return this.contentRenderer.render(WEB_PANEL_LOCATION, (Map)projectContext.build());
    }
}

