/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.web.pagedata;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.cdn.CDNStrategy;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class WebpackDataProvider {
    private JiraAuthenticationContext jiraAuthenticationContext;
    private WebResourceUrlProvider webResourceUrlProvider;
    private WebResourceIntegration webResourceIntegration;

    @Autowired
    public WebpackDataProvider(JiraAuthenticationContext jiraAuthenticationContext, WebResourceUrlProvider webResourceUrlProvider, WebResourceIntegration webResourceIntegration) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.webResourceIntegration = webResourceIntegration;
    }

    public Map<String, Object> getData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("locale", this.jiraAuthenticationContext.getLocale().toString().replaceAll("_", "-"));
        String webpackDevServer = System.getProperty("webpack.dev.server");
        if (webpackDevServer != null) {
            data.put("publicPath", webpackDevServer + "/");
        } else {
            String resourceUrl = this.webResourceUrlProvider.getStaticPluginResourceUrl("com.atlassian.servicedesk:webpack-async-chunks", "", UrlMode.RELATIVE);
            CDNStrategy cdnStrategy = this.webResourceIntegration.getCDNStrategy();
            if (cdnStrategy != null) {
                String cdnResourceUrl = this.webResourceIntegration.getCDNStrategy().transformRelativeUrl(resourceUrl);
                data.put("publicPath", cdnResourceUrl);
            } else {
                data.put("publicPath", resourceUrl);
            }
        }
        return data;
    }
}

