/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.web.pagedata;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.ErrorCode;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.feature.applink.ServiceDeskAppLinkService;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseService;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KbLinkDataProvider {
    private final ConfluenceKnowledgeBaseService confluenceKnowledgeBaseService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ServiceDeskAppLinkService serviceDeskAppLinkService;

    @Autowired
    public KbLinkDataProvider(ConfluenceKnowledgeBaseService confluenceKnowledgeBaseService, JiraAuthenticationContext jiraAuthenticationContext, ServiceDeskAppLinkService serviceDeskAppLinkService) {
        this.confluenceKnowledgeBaseService = confluenceKnowledgeBaseService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.serviceDeskAppLinkService = serviceDeskAppLinkService;
    }

    @Nonnull
    public Map<String, Object> kbLinkData(@Nonnull Project project) {
        return (Map)Option.option((Object)this.jiraAuthenticationContext.getLoggedInUser()).map(user -> this.getKbLinkData((ApplicationUser)user, project)).getOrElse((Object)Maps.newHashMap());
    }

    private Map<String, Object> getKbLinkData(ApplicationUser loggedInUser, Project project) {
        Either kbLinkData = Steps.begin((Either)this.confluenceKnowledgeBaseService.getKBLink(loggedInUser, project)).then(kbLink -> this.serviceDeskAppLinkService.getApplicationLink(kbLink.getApplicationId())).yield((kbLink, applicationLink) -> {
            HashMap<String, Object> kbLinkMap = new HashMap<String, Object>();
            kbLinkMap.put("id", Integer.toString(kbLink.getId()));
            kbLinkMap.put("spaceKey", kbLink.getSpaceKey());
            kbLinkMap.put("baseUrl", applicationLink.getDisplayUrl());
            return kbLinkMap;
        });
        return (Map)kbLinkData.fold(error -> {
            HashMap errorMap = new HashMap();
            HashMap<String, String> errorDetails = new HashMap<String, String>();
            errorDetails.put("message", error.getMessage().getMessage());
            String errorCode = (String)error.getErrorCode().fold(() -> (String)error.getMessage().getI18n().map(ErrorMessage.I18n::getI18nKey).getOrElse((Object)""), ErrorCode::getErrorCode);
            errorDetails.put("key", errorCode);
            errorMap.put("error", errorDetails);
            return errorMap;
        }, data -> data);
    }
}

