/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.web.action;

import com.atlassian.servicedesk.project.internal.util.PluginHelper;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;

public enum ProjectPage {
    QUEUES("queues", PluginHelper.completeKeyFor("sd-project-sidebar-queues"), PluginHelper.completeKeyFor("sd-project-sidebar-queues-renaissance"), Lists.newArrayList((Object[])new String[]{"com.atlassian.servicedesk.project-ui:page-queues"}), Lists.newArrayList((Object[])new String[]{"jira.view.issue", "jira.view.issue.deferred", "sd.project.queue"})),
    ISSUE("issue", PluginHelper.completeKeyFor("sd-project-sidebar-queues"), PluginHelper.completeKeyFor("sd-project-sidebar-queues-renaissance"), Lists.newArrayList((Object[])new String[]{"com.atlassian.servicedesk.project-ui:page-queues"}), Lists.newArrayList((Object[])new String[]{"jira.view.issue", "jira.view.issue.deferred", "sd.project.queue"})),
    REPORT("reports", PluginHelper.completeKeyFor("sd-project-sidebar-reports"), PluginHelper.completeKeyFor("sd-project-sidebar-reports-renaissance"), Lists.newArrayList((Object[])new String[]{"com.atlassian.servicedesk.project-ui:page-reports"}), Lists.newArrayList((Object[])new String[]{"sd.project.report"})),
    SLA("sla", PluginHelper.completeKeyFor("sd-project-sidebar-sla"), Lists.newArrayList((Object[])new String[]{"com.atlassian.servicedesk.project-ui:page-sla"})),
    PEOPLE("people", PluginHelper.completeKeyFor("sd-project-sidebar-people"), Lists.newArrayList((Object[])new String[]{"com.atlassian.servicedesk:agent-view-people"})),
    CUSTOMERS("customers", PluginHelper.completeKeyFor("sd-project-sidebar-customers"), PluginHelper.completeKeyFor("sd-project-sidebar-customers-renaissance"), (List<String>)Lists.newArrayList((Object[])new String[]{"com.atlassian.servicedesk.project-ui:page-legacy-customers"})),
    ORGANISATION("organization", Lists.newArrayList((Object[])new String[]{"com.atlassian.servicedesk.project-ui:page-organisation"})),
    PROJECT_SETTINGS("project-settings", PluginHelper.completeKeyFor("sd-project-sidebar-project-settings"), Collections.emptyList()),
    WELCOME_GUIDE("welcome-guide", PluginHelper.completeKeyFor("sd-project-sidebar-welcome-guide"), Lists.newArrayList((Object[])new String[]{"com.atlassian.servicedesk:welcome-guide"})),
    REQUEST_TYPES("request-types", PluginHelper.completeKeyFor("sd-project-request-types-item"), Lists.newArrayList((Object[])new String[]{"com.atlassian.servicedesk.project-ui:page-request-types"})),
    REQUEST_SECURITY("request-security", PluginHelper.completeKeyFor("sd-project-request-security-item"), Lists.newArrayList((Object[])new String[]{"com.atlassian.servicedesk.project-ui:page-request-security"})),
    AUTOMATION("automation", PluginHelper.completeKeyFor("sd-project-automation-item"), Lists.newArrayList((Object[])new String[]{"com.atlassian.servicedesk.project-ui:page-automation"})),
    PORTAL_SETTINGS("portal-settings", PluginHelper.completeKeyFor("sd-project-portal-settings-item"), Lists.newArrayList((Object[])new String[]{"com.atlassian.servicedesk.project-ui:page-portal-settings"})),
    FEEDBACK_SETTINGS("feedback-settings", PluginHelper.completeKeyFor("sd-project-feedback-settings-item"), Lists.newArrayList((Object[])new String[]{"com.atlassian.servicedesk.project-ui:page-feedback-settings"})),
    EMAIL_SETTINGS("email-settings", PluginHelper.completeKeyFor("sd-project-email-settings-item"), Lists.newArrayList((Object[])new String[]{"com.atlassian.servicedesk.project-ui:page-incoming-email"})),
    EMAIL_NOTIFICATION_SETTINGS("customer-notifications", "com.atlassian.servicedesk.servicedesk-notification-plugin:sd-project-outgoing-email-settings-item", Lists.newArrayList((Object[])new String[]{"com.atlassian.servicedesk.servicedesk-notification-plugin:page-outgoing-email"})),
    CONFLUENCE_KB("confluence-kb", PluginHelper.completeKeyFor("sd-project-confluence-kb-item"), Lists.newArrayList((Object[])new String[]{"com.atlassian.servicedesk.project-ui:page-kb-settings"}));

    private final String path;
    private final String sidebarItemKey;
    private final List<String> webResourceContexts;
    private final List<String> webResources;
    private String sidebarItemKeyInRenaissance;

    private ProjectPage(String path, String sidebarItemKey, List<String> webResources, List<String> webResourceContexts) {
        this.path = path;
        this.sidebarItemKey = sidebarItemKey;
        this.sidebarItemKeyInRenaissance = sidebarItemKey;
        this.webResourceContexts = webResourceContexts;
        this.webResources = webResources;
    }

    private ProjectPage(String path, String sidebarItemKey, String sidebarItemKeyInRenaissance, List<String> webResources, List<String> webResourceContexts) {
        this(path, sidebarItemKey, webResources, webResourceContexts);
        this.sidebarItemKeyInRenaissance = sidebarItemKeyInRenaissance;
    }

    private ProjectPage(String path, String sidebarItemKey, List<String> webResources) {
        this(path, sidebarItemKey, webResources, (List<String>)Lists.newArrayList());
    }

    private ProjectPage(String path, List<String> webResources) {
        this(path, null, webResources, (List<String>)Lists.newArrayList());
    }

    private ProjectPage(String path, String sidebarItemKey, String sidebarItemKeyInRenaissance, List<String> webResources) {
        this(path, sidebarItemKey, webResources);
        this.sidebarItemKeyInRenaissance = sidebarItemKeyInRenaissance;
    }

    public static Option<ProjectPage> fromPath(String path) {
        for (ProjectPage page : ProjectPage.values()) {
            if (!page.path.equals(path)) continue;
            return Option.some((Object)((Object)page));
        }
        return Option.none();
    }

    public String getPath() {
        return this.path;
    }

    public String getSidebarItemKey() {
        return this.sidebarItemKeyInRenaissance;
    }

    public List<String> getWebResources() {
        return this.webResources;
    }

    public List<String> getWebResourceContexts() {
        return this.webResourceContexts;
    }
}

