/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.web.action;

import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutManager;
import com.atlassian.jira.projects.api.sidebar.ProjectSidebarRenderer;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.web.action.util.FieldsResourceIncluder;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.eyeball.EyeballService;
import com.atlassian.servicedesk.project.internal.condition.ShowWelcomeGuideCondition;
import com.atlassian.servicedesk.project.internal.context.ServiceDeskProjectContext;
import com.atlassian.servicedesk.project.internal.context.ServiceDeskProjectContextProvider;
import com.atlassian.servicedesk.project.internal.soy.SoyRenderer;
import com.atlassian.servicedesk.project.internal.web.action.PageLanguageTools;
import com.atlassian.servicedesk.project.internal.web.action.ProjectActionSupport;
import com.atlassian.servicedesk.project.internal.web.action.ProjectPage;
import com.atlassian.servicedesk.project.internal.web.pagedata.ProjectDataAssembler;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectApplicationAction
extends ProjectActionSupport {
    private final ProjectSidebarRenderer projectSidebarRenderer;
    private final KeyboardShortcutManager keyboardShortcutManager;
    private final FieldsResourceIncluder fieldsResourceIncluder;
    private final XsrfTokenGenerator xsrfTokenGenerator;
    private final ServiceDeskProjectContextProvider serviceDeskProjectContextProvider;
    private final PluginAccessor pluginAccessor;
    private final ProjectDataAssembler projectDataAssembler;
    private Option<ProjectPage> page;

    @Autowired
    public ProjectApplicationAction(EyeballService eyeballService, SoyRenderer soyRenderer, PageBuilderService pageBuilderService, ProjectSidebarRenderer projectSidebarRenderer, KeyboardShortcutManager keyboardShortcutManager, FieldsResourceIncluder fieldsResourceIncluder, XsrfTokenGenerator xsrfTokenGenerator, ServiceDeskProjectContextProvider serviceDeskProjectContextProvider, PluginAccessor pluginAccessor, ProjectDataAssembler projectDataAssembler) {
        super(eyeballService, soyRenderer, pageBuilderService);
        this.projectSidebarRenderer = projectSidebarRenderer;
        this.keyboardShortcutManager = keyboardShortcutManager;
        this.fieldsResourceIncluder = fieldsResourceIncluder;
        this.xsrfTokenGenerator = xsrfTokenGenerator;
        this.serviceDeskProjectContextProvider = serviceDeskProjectContextProvider;
        this.pluginAccessor = pluginAccessor;
        this.projectDataAssembler = projectDataAssembler;
    }

    public void setPage(String path) {
        this.page = ProjectPage.fromPath(path);
    }

    private void render(ServiceDeskProjectContext context, ProjectPage currentPage) {
        this.projectDataAssembler.assembleData(context);
        this.assembleRequiredResources(currentPage);
        this.setSuccessfulForMau();
        this.renderSoy("com.atlassian.servicedesk.project-ui:soy", "ServiceDesk.Project.Templates.page", this.getRenderParams(context, currentPage));
    }

    private boolean isValidPageView(ServiceDeskProjectContext projectContext) {
        if (this.page.isEmpty()) {
            return false;
        }
        ProjectPage currentPage = (ProjectPage)((Object)this.page.get());
        if (ProjectPage.WELCOME_GUIDE.equals((Object)currentPage)) {
            ShowWelcomeGuideCondition condition = this.autowire(ShowWelcomeGuideCondition.class);
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("user", this.getLoggedInUser());
            context.put("project", projectContext.getProject());
            return condition.shouldDisplay(context);
        }
        return true;
    }

    public String doView() {
        Either<AnError, ServiceDeskProjectContext> projectContextResult = this.serviceDeskProjectContextProvider.getContext(this.projectKey);
        if (projectContextResult.isLeft()) {
            this.renderError((AnError)projectContextResult.left().get());
            return null;
        }
        ServiceDeskProjectContext context = (ServiceDeskProjectContext)projectContextResult.right().get();
        if (!this.isValidPageView(context)) {
            return this.getRedirect(ProjectPage.QUEUES.getPath());
        }
        ProjectPage currentPage = (ProjectPage)((Object)this.page.get());
        this.xsrfTokenGenerator.generateToken(this.getHttpRequest());
        this.render(context, currentPage);
        return null;
    }

    private Map<String, Object> getRenderParams(ServiceDeskProjectContext context, ProjectPage currentPage) {
        return ImmutableMap.of((Object)"title", (Object)context.getProject().getName(), (Object)"sidebarContent", (Object)this.getSidebarContent(context, currentPage));
    }

    private String getSidebarContent(ServiceDeskProjectContext context, ProjectPage currentPage) {
        String selectedItemKey = currentPage.getSidebarItemKey();
        return this.projectSidebarRenderer.render(context.getProject(), selectedItemKey);
    }

    private void assembleRequiredResources(ProjectPage currentPage) {
        this.getAssembler().resources().requireContext("jira.browse.project").requireContext("jira.project.sidebar");
        PageLanguageTools.includeLanaguage(this.getAssembler(), this.getLocale());
        this.assembleRequiredResources(currentPage, "sd.project.view", "sd.project.api");
        this.fieldsResourceIncluder.includeFieldResourcesForCurrentUser();
        this.keyboardShortcutManager.requireShortcutsForContext(KeyboardShortcutManager.Context.issueaction);
    }

    private <T> T autowire(Class<T> componentClass) {
        ContainerManagedPlugin plugin = (ContainerManagedPlugin)this.pluginAccessor.getPlugin("com.atlassian.servicedesk.project-ui");
        return (T)plugin.getContainerAccessor().createBean(componentClass);
    }
}

