/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.web.action;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.eyeball.EyeballService;
import com.atlassian.servicedesk.internal.spi.action.ServiceDeskWebActionSupport;
import com.atlassian.servicedesk.project.internal.soy.SoyRenderer;
import com.atlassian.servicedesk.project.internal.web.action.ProjectPage;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.RequiredResources;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import webwork.action.ActionContext;

abstract class ProjectActionSupport
extends ServiceDeskWebActionSupport {
    private final SoyRenderer soyRenderer;
    private final PageBuilderService pageBuilderService;
    protected String projectKey;

    public ProjectActionSupport(EyeballService eyeballService, SoyRenderer soyRenderer, PageBuilderService pageBuilderService) {
        super(eyeballService);
        this.soyRenderer = soyRenderer;
        this.pageBuilderService = pageBuilderService;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    protected void assembleRequiredResources(ProjectPage page, String ... contexts) {
        Assertions.notNull((String)"contexts", (Object)contexts);
        List<String> contextList = Arrays.asList(contexts);
        Assertions.notEmpty((String)"contexts", contextList);
        RequiredResources resourcesAssembler = this.pageBuilderService.assembler().resources();
        contextList.forEach(arg_0 -> ((RequiredResources)resourcesAssembler).requireContext(arg_0));
        page.getWebResources().forEach(arg_0 -> ((RequiredResources)resourcesAssembler).requireWebResource(arg_0));
        page.getWebResourceContexts().forEach(arg_0 -> ((RequiredResources)resourcesAssembler).requireContext(arg_0));
    }

    protected void renderSoy(String resourceKey, String templateAddress, Map<String, Object> params) {
        HttpServletResponse executingResponse = ActionContext.getResponse();
        executingResponse.setContentType(executingResponse.getContentType());
        try {
            this.soyRenderer.render(executingResponse.getWriter(), resourceKey, templateAddress, params);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void renderSoy(String resourceKey, String templateAddress) {
        this.renderSoy(resourceKey, templateAddress, new HashMap<String, Object>());
    }

    protected void renderError(AnError error) {
        String translatedError = this.getTranslatedErrorMessage(error);
        this.renderSoy("com.atlassian.servicedesk.project-ui:soy", "ServiceDesk.Project.Templates.errorPage", (Map<String, Object>)ImmutableMap.of((Object)"errorMessage", (Object)translatedError));
    }

    protected WebResourceAssembler getAssembler() {
        return this.pageBuilderService.assembler();
    }

    private String getTranslatedErrorMessage(AnError error) {
        return (String)error.getMessage().getI18n().map(i18n -> this.getI18nHelper().getText(i18n.getI18nKey(), (Object)i18n.getParams())).getOrElse((Object)error.getMessage().getMessage());
    }
}

