/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.web.action;

import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class PageLanguageTools {
    private static final String[] momentJSSupportedLanguages = new String[]{"af", "ar-ma", "ar-sa", "ar-tn", "ar", "az", "be", "bg", "bn", "bo", "br", "bs", "ca", "cs", "cv", "cy", "da", "de-at", "de", "el", "en-au", "en-ca", "en-gb", "eo", "es", "et", "eu", "fa", "fi", "fo", "fr-ca", "fr", "fy", "gl", "he", "hi", "hr", "hu", "hy-am", "id", "is", "it", "ja", "jv", "ka", "km", "ko", "lb", "lt", "lv", "me", "mk", "ml", "mr", "ms-my", "my", "nb", "ne", "nl", "nn", "pl", "pt-br", "pt", "ro", "ru", "si", "sk", "sl", "sq", "sr-cyrl", "sr", "sv", "ta", "th", "tl-ph", "tr", "tzm-latn", "tzm", "uk", "uz", "vi", "zh-cn", "zh-tw"};
    private static final List<String> momentJSSupportedLanaguagesList = Arrays.asList(momentJSSupportedLanguages);

    private static void includeMomentJS(WebResourceAssembler webResourceAssembler, Locale locale) {
        webResourceAssembler.resources().requireWebResource("com.atlassian.servicedesk.core-ui:lib-moment");
        String language = locale.toString().toLowerCase().replace("_", "-");
        if (!language.equals("en") && !momentJSSupportedLanaguagesList.contains(language)) {
            language = locale.getLanguage().toLowerCase().replace("_", "-");
        }
        webResourceAssembler.data().requireData("moment_user_locale", locale.toString());
        if (!language.equals("en") && momentJSSupportedLanaguagesList.contains(language)) {
            webResourceAssembler.resources().requireWebResource("com.atlassian.servicedesk.core-ui:momentjs-sd-" + language);
        }
    }

    public static void includeLanaguage(WebResourceAssembler webResourceAssembler, Locale locale) {
        if (locale == null) {
            return;
        }
        PageLanguageTools.includeMomentJS(webResourceAssembler, locale);
    }
}

