/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.util;

import com.sun.jersey.api.uri.UriTemplate;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class RedirectRule {
    private final UriTemplate fromUrlTemplate;
    private final UriTemplate toUrlTemplate;
    private final Map<String, String> pageMappings;

    public RedirectRule(UriTemplate fromUrlPrefixTemplate, UriTemplate toUrlPrefixMapper) {
        this(fromUrlPrefixTemplate, toUrlPrefixMapper, new HashMap<String, String>());
    }

    public RedirectRule(UriTemplate fromUrlPrefixTemplate, UriTemplate toUrlPrefixMapper, Map<String, String> pageMappings) {
        this.fromUrlTemplate = new UriTemplate(fromUrlPrefixTemplate.getTemplate() + "{pagePath:.*}");
        this.toUrlTemplate = new UriTemplate(toUrlPrefixMapper.getTemplate() + "{pagePath:.*}");
        this.pageMappings = pageMappings;
    }

    public Option<String> getRedirectUrl(String url) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.fromUrlTemplate.match((CharSequence)url, params)) {
            this.mapPagePath(params);
            return Option.some((Object)this.toUrlTemplate.createURI(params));
        }
        return Option.none();
    }

    private void mapPagePath(Map<String, String> params) {
        String pagePath = params.get("pagePath");
        for (Map.Entry<String, String> entry : this.pageMappings.entrySet()) {
            String oldPage = entry.getKey();
            String newPage = entry.getValue();
            if (!StringUtils.startsWith((String)pagePath, (String)oldPage)) continue;
            String newPagePath = StringUtils.replaceOnce((String)pagePath, (String)oldPage, (String)newPage);
            params.put("pagePath", newPagePath);
            return;
        }
    }
}

