/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.util;

import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.applink.ServiceDeskAppLinkService;
import io.atlassian.fugue.Option;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConditionHelper {
    private final ServiceDeskService serviceDeskService;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final ServiceDeskAppLinkService serviceDeskAppLinkService;
    private final UserFactory userFactory;

    @Autowired
    public ConditionHelper(ServiceDeskService serviceDeskService, ServiceDeskPermissionService serviceDeskPermissionService, ServiceDeskAppLinkService serviceDeskAppLinkService, UserFactory userFactory) {
        this.serviceDeskService = serviceDeskService;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.serviceDeskAppLinkService = serviceDeskAppLinkService;
        this.userFactory = userFactory;
    }

    public boolean isAgentAdmin(Map<String, Object> map) {
        io.atlassian.fugue.Either adminAgentResult;
        Project project;
        ApplicationUser user;
        io.atlassian.fugue.Either serviceDesk;
        Object userObj = map.get("user");
        Object projectObj = map.get("project");
        if (userObj != null && projectObj != null && (serviceDesk = StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user = (ApplicationUser)userObj, project = (Project)projectObj))).isRight() && (adminAgentResult = StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAdminAgent(user, (ServiceDesk)serviceDesk.right().get()))).isRight()) {
            return (Boolean)adminAgentResult.right().get();
        }
        return false;
    }

    public boolean isAgent(Map<String, Object> map) {
        Object userObj = map.get("user");
        Object projectObj = map.get("project");
        if (userObj != null && projectObj != null) {
            ApplicationUser user = (ApplicationUser)userObj;
            Project project = (Project)projectObj;
            return (Boolean)this.serviceDeskService.getServiceDeskForProject(user, project).flatMap(sd -> this.serviceDeskPermissionService.isAgent(user, sd)).getOrElse((Object)false);
        }
        return false;
    }

    public boolean isAtLeastOneConfluenceApplicationLinked(Map<String, Object> map) {
        return (Boolean)Steps.begin((Option)Option.option((Object)map.get("project")).map(obj -> (Project)obj)).then(project -> this.getUser(map)).then((project, user) -> this.serviceDeskAppLinkService.getAllApplicationLinksForType(user, project, ConfluenceApplicationType.class).toOption()).yield((project, user, links) -> links.size() > 0).getOrElse((Object)false);
    }

    private Option<CheckedUser> getUser(Map<String, Object> map) {
        return Steps.begin((Option)Option.option((Object)map.get("user")).map(obj -> (ApplicationUser)obj)).then(applicationUser -> StepsConverters.newerOption((com.atlassian.fugue.Option)this.userFactory.wrap(applicationUser).toOption())).yield((applicationUser, checkedUser) -> checkedUser);
    }
}

