/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.routing.unlicensed;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.internal.api.project.type.ServiceDeskProjectType;
import com.atlassian.servicedesk.project.internal.permissions.PermissionsUtil;
import com.atlassian.servicedesk.project.internal.routing.unlicensed.UnlicensedRoute;
import com.atlassian.servicedesk.project.internal.routing.unlicensed.UnlicensedRouteMapping;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UnlicensedRouteProvider {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionsUtil permissionsUtil;
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final FeatureManager featureManager;

    @Autowired
    public UnlicensedRouteProvider(JiraAuthenticationContext jiraAuthenticationContext, PermissionsUtil permissionsUtil, ProjectManager projectManager, PermissionManager permissionManager, FeatureManager featureManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionsUtil = permissionsUtil;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.featureManager = featureManager;
    }

    private Option<UnlicensedRoute> getRedirect(String servletPath) {
        for (UnlicensedRouteMapping mapping : UnlicensedRouteMapping.values()) {
            Option<UnlicensedRoute> redirect = mapping.getRoute(servletPath);
            if (!redirect.isDefined()) continue;
            return redirect;
        }
        return Option.none();
    }

    public Option<UnlicensedRoute> getRoute(String servletRequestPath) {
        Option<UnlicensedRoute> redirect = this.getRedirect(servletRequestPath);
        if (!redirect.isDefined()) {
            return Option.none();
        }
        UnlicensedRoute unlicensedRoute = (UnlicensedRoute)redirect.get();
        String projectKey = unlicensedRoute.getParams().get("projectKey");
        Project project = this.projectManager.getProjectByCurrentKey(projectKey);
        if (project == null || !ServiceDeskProjectType.KEY.equals((Object)project.getProjectTypeKey())) {
            return Option.none();
        }
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        boolean isAgent = this.permissionsUtil.isAgentForProject(user, projectKey);
        if (isAgent) {
            return Option.none();
        }
        if (!this.hasRequirePermissions(unlicensedRoute, project, user)) {
            return Option.none();
        }
        return Option.some((Object)unlicensedRoute);
    }

    private boolean hasRequirePermissions(UnlicensedRoute unlicensedRoute, Project project, ApplicationUser user) {
        return unlicensedRoute.getRequiredProjectAction().hasPermission(this.permissionManager, user, project);
    }
}

