/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.routing.unlicensed;

import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.servicedesk.project.internal.routing.unlicensed.UnlicensedRoute;
import com.atlassian.servicedesk.project.internal.web.action.ProjectPage;
import com.google.common.collect.Lists;
import com.sun.jersey.api.uri.UriTemplate;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.List;

public enum UnlicensedRouteMapping {
    JIRA_PROJECT_ADMIN("/servicedesk/admin/{projectKey}", (Option<String>)Option.some((Object)"projectAdmin"), ProjectAction.EDIT_PROJECT_CONFIG),
    PROJECT_VIEW("/projects/{projectKey}", (Option<String>)Option.none(), ProjectAction.VIEW_ISSUES);

    private static final String REDIRECT_TEMPLATE = "/secure/UnlicensedApplicationAction.jspa?projectKey=%s&decorator=%s&selectedItemId=%s";
    private final Option<String> decorator;
    private final ProjectAction projectAction;
    private final List<UriTemplate> matchers;

    private UnlicensedRouteMapping(String baseUrl, Option<String> decorator, ProjectAction projectAction) {
        this.decorator = decorator;
        this.projectAction = projectAction;
        this.matchers = Lists.newArrayList((Object[])new UriTemplate[]{new UriTemplate(baseUrl + "/{page}"), new UriTemplate(baseUrl + "/{page}/{subResources:.*}")});
    }

    public Option<UnlicensedRoute> getRoute(String servletPath) {
        for (UriTemplate matcher : this.matchers) {
            HashMap<String, String> params;
            if (!matcher.match((CharSequence)servletPath, params = new HashMap<String, String>())) continue;
            String projectKey = (String)params.get("projectKey");
            String decorator = (String)this.decorator.getOrElse((Object)"");
            Option<ProjectPage> page = ProjectPage.fromPath((String)params.get("page"));
            String selectedItemId = page.isDefined() ? ((ProjectPage)((Object)page.get())).getSidebarItemKey() : "";
            String uri = String.format(REDIRECT_TEMPLATE, projectKey, decorator, selectedItemId);
            UnlicensedRoute unlicensedRoute = new UnlicensedRoute(uri, params, this.projectAction);
            return Option.option((Object)unlicensedRoute);
        }
        return Option.none();
    }
}

