/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.routing.projecttype;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.project.internal.permissions.PermissionsUtil;
import com.atlassian.servicedesk.project.internal.routing.projecttype.ServiceDeskProjectTypeRoute;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.sun.jersey.api.uri.UriTemplate;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskProjectTypeRouteProvider {
    private static final UriTemplate OLD_BASE_PATH_PREFIX = new UriTemplate("/servicedesk/agent/{projectKey}/");
    private static final UriTemplate OLD_BASE_PATH_MATCHER = new UriTemplate(OLD_BASE_PATH_PREFIX.getTemplate() + "{subResources:.*}");
    private static final UriTemplate NEW_BASE_PATH_PREFIX = new UriTemplate("/projects/{projectKey}/");
    private static final UriTemplate NEW_BASE_PATH_MATCHER = new UriTemplate(NEW_BASE_PATH_PREFIX.getTemplate() + "{subResources:.*}");
    private static final UriTemplate DEFAULT_PAGE_MAPPING = new UriTemplate("/secure/ProjectAppAction.jspa?projectKey={projectKey}&page={page}");
    private static final UriTemplate DEFAULT_PAGE_MAPPING_WITH_QUERY = new UriTemplate(DEFAULT_PAGE_MAPPING.getTemplate() + "&{queryString}");
    private static final List<String> PAGE_MATCHERS = Lists.newArrayList((Object[])new String[]{"{page}", "{page}/{subResources:.*}"});
    private static final List<String> ANONYMOUS_PAGES = Lists.newArrayList((Object[])new String[]{"invite"});
    @TenantAware(value=TenancyScope.TENANTLESS)
    private static final Map<String, UriTemplate> PAGE_MAPPING_OVERRIDES = ImmutableMap.of((Object)"invite", (Object)new UriTemplate("/secure/AcceptInvitation.jspa?projectKey={projectKey}&{queryString}"));
    private final ProjectManager projectManager;
    private final ServiceDeskManager serviceDeskManager;
    private final PermissionsUtil permissionsUtil;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public ServiceDeskProjectTypeRouteProvider(ServiceDeskManager serviceDeskManager, ProjectManager projectManager, JiraAuthenticationContext jiraAuthenticationContext, PermissionsUtil permissionsUtil) {
        this.serviceDeskManager = serviceDeskManager;
        this.projectManager = projectManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionsUtil = permissionsUtil;
    }

    public Option<ServiceDeskProjectTypeRoute> getRoute(String servletRequestPath, String queryString) {
        Option<ServiceDeskProjectTypeRoute> pageUrlRoute = this.getRouteForPage(servletRequestPath, queryString);
        if (pageUrlRoute.isDefined()) {
            return pageUrlRoute;
        }
        return Option.none();
    }

    private Option<ServiceDeskProjectTypeRoute> getRouteForPage(String servletRequestPath, String queryString) {
        Option<UriTemplate> prefixTemplateOption = this.getBaseUrlForPage(servletRequestPath);
        if (prefixTemplateOption.isEmpty()) {
            return Option.none();
        }
        UriTemplate prefix = (UriTemplate)prefixTemplateOption.get();
        for (String mapping : PAGE_MATCHERS) {
            HashMap<String, String> params;
            UriTemplate uriTemplate = new UriTemplate(prefix.getTemplate() + mapping);
            if (!uriTemplate.match((CharSequence)servletRequestPath, params = new HashMap<String, String>())) continue;
            String basePath = prefix.createURI(params).replaceAll("/$", "");
            String page = (String)params.get("page");
            Option<String> destination = this.getDestinationForParams(page, params, queryString);
            if (!destination.isDefined()) continue;
            boolean authenticated = !ANONYMOUS_PAGES.contains(page);
            return Option.some((Object)new ServiceDeskProjectTypeRoute(basePath, servletRequestPath, (String)destination.get(), authenticated));
        }
        return Option.none();
    }

    private Option<UriTemplate> getBaseUrlForPage(String servletRequestPath) {
        String projectKey;
        Project project;
        HashMap params = new HashMap();
        if (OLD_BASE_PATH_MATCHER.match((CharSequence)servletRequestPath, params)) {
            return Option.some((Object)OLD_BASE_PATH_PREFIX);
        }
        if (NEW_BASE_PATH_MATCHER.match((CharSequence)servletRequestPath, params) && this.serviceDeskManager.getServiceDeskForProject(project = this.projectManager.getProjectByCurrentKey(projectKey = (String)params.get("projectKey"))).isRight()) {
            return Option.some((Object)NEW_BASE_PATH_PREFIX);
        }
        return Option.none();
    }

    private Option<String> getDestinationForParams(String page, HashMap<String, String> params, String queryString) {
        UriTemplate override = PAGE_MAPPING_OVERRIDES.get(page);
        params.put("queryString", queryString);
        if (override != null) {
            return Option.some((Object)override.createURI(params));
        }
        String projectKey = params.get("projectKey");
        boolean isAgent = this.permissionsUtil.isAgentForProject(this.jiraAuthenticationContext.getLoggedInUser(), projectKey);
        if (!isAgent) {
            return Option.none();
        }
        if (queryString != null && !queryString.isEmpty()) {
            return Option.some((Object)DEFAULT_PAGE_MAPPING_WITH_QUERY.createURI(params));
        }
        return Option.some((Object)DEFAULT_PAGE_MAPPING.createURI(params));
    }
}

